/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 6192047123024651924L;
    private final StringBuilder pointerToViolation;
    private final transient Schema violatedSchema;
    private final List<ValidationException> causingExceptions;

    public static void throwFor(Schema rootFailingSchema, List<ValidationException> failures) {
        int failureCount = failures.size();
        if (failureCount == 0) {
            return;
        }
        if (failureCount == 1) {
            throw failures.get(0);
        }
        throw new ValidationException(rootFailingSchema, new ArrayList<ValidationException>(failures));
    }

    @Deprecated
    public ValidationException(Class<?> expectedType, Object actualValue) {
        this(null, expectedType, actualValue);
    }

    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue) {
        this(violatedSchema, new StringBuilder("#"), "expected type: " + expectedType.getSimpleName() + ", found: " + (actualValue == null ? "null" : actualValue.getClass().getSimpleName()), Collections.emptyList());
    }

    private ValidationException(Schema rootFailingSchema, List<ValidationException> causingExceptions) {
        this(rootFailingSchema, new StringBuilder("#"), causingExceptions.size() + " schema violations found", causingExceptions);
    }

    public ValidationException(Schema violatedSchema, String message) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList());
    }

    ValidationException(Schema violatedSchema, StringBuilder pointerToViolation, String message, List<ValidationException> causingExceptions) {
        super(message);
        this.violatedSchema = violatedSchema;
        this.pointerToViolation = pointerToViolation;
        this.causingExceptions = Collections.unmodifiableList(causingExceptions);
    }

    @Deprecated
    public ValidationException(String message) {
        this((Schema)null, new StringBuilder("#"), message, Collections.emptyList());
    }

    private ValidationException(StringBuilder pointerToViolation, Schema violatedSchema, String message, List<ValidationException> causingExceptions) {
        this(violatedSchema, pointerToViolation, message, causingExceptions);
    }

    private String escapeFragment(String fragment) {
        return fragment.replace("~", "~0").replace("/", "~1");
    }

    public List<ValidationException> getCausingExceptions() {
        return this.causingExceptions;
    }

    @Override
    public String getMessage() {
        return this.getPointerToViolation() + ": " + super.getMessage();
    }

    public String getPointerToViolation() {
        return this.pointerToViolation.toString();
    }

    public Schema getViolatedSchema() {
        return this.violatedSchema;
    }

    public ValidationException prepend(String fragment) {
        return this.prepend(fragment, this.violatedSchema);
    }

    public ValidationException prepend(String fragment, Schema violatedSchema) {
        String escapedFragment = this.escapeFragment(Objects.requireNonNull(fragment, "fragment cannot be null"));
        StringBuilder newPointer = this.pointerToViolation.insert(1, '/').insert(2, escapedFragment);
        List<ValidationException> prependedCausingExceptions = this.causingExceptions.stream().map(exc -> exc.prepend(escapedFragment)).collect(Collectors.toList());
        return new ValidationException(newPointer, violatedSchema, super.getMessage(), prependedCausingExceptions);
    }
}

