/*
 * Decompiled with CFR 0.152.
 */
package br.com.mzsw;

import br.com.mzsw.BalancaListener;
import br.com.mzsw.PesoLibWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PesoLib
implements Runnable {
    private List<BalancaListener> listeners = new ArrayList<BalancaListener>();
    private PesoLibWrapper driver = new PesoLibWrapper();
    private long instance;
    private boolean canceled;
    private int ultimoPeso;

    public PesoLib() {
        this.instance = this.driver.criar("");
        if (this.instance == 0L) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar uma inst\u00e2ncia da biblioteca");
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public PesoLib(String configuracao) {
        this.instance = this.driver.criar(configuracao);
        if (this.instance == 0L) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar uma inst\u00e2ncia da biblioteca");
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void addEventListener(BalancaListener l) {
        this.listeners.add(l);
    }

    public void fecha() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        this.driver.cancela(this.instance);
        this.driver.libera(this.instance);
        this.instance = 0L;
    }

    private void needActive() {
        if (this.canceled) {
            throw new RuntimeException("A instancia da biblioteca j\u00e1 foi liberada");
        }
    }

    public void setPreco(float preco) {
        this.needActive();
        if (!this.driver.solicitaPeso(this.instance, preco)) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel ajustar o pre\u00e7o do item da bala\u00e7a");
        }
    }

    public void askPeso() {
        this.setPreco(0.0f);
    }

    public boolean isConectado() {
        if (this.canceled) {
            return true;
        }
        return this.driver.isConectado(this.instance);
    }

    public void setConfiguracao(String configuracao) {
        this.needActive();
        this.driver.setConfiguracao(this.instance, configuracao);
    }

    public String getConfiguracao() {
        this.needActive();
        return this.driver.getConfiguracao(this.instance);
    }

    public int getUltimoPeso() {
        return this.ultimoPeso;
    }

    public List<String> getMarcas() {
        this.needActive();
        String marcas = this.driver.getMarcas(this.instance);
        return Arrays.asList(marcas.split("\r\n"));
    }

    public List<String> getModelos(String marca) {
        this.needActive();
        String modelos = this.driver.getModelos(this.instance, marca);
        return Arrays.asList(modelos.split("\r\n"));
    }

    public String getVersao() {
        return this.driver.getVersao(this.instance);
    }

    @Override
    public void run() {
        int event;
        do {
            event = this.driver.aguardaEvento(this.instance);
            switch (event) {
                case 0: {
                    break;
                }
                case 1: {
                    this.postEventConnect();
                    break;
                }
                case 2: {
                    this.postEventDisconnect();
                    break;
                }
                default: {
                    this.postEventWeightReceived(this.driver.getUltimoPeso(this.instance));
                }
            }
        } while (!this.canceled && event != 0);
    }

    private void postEventConnect() {
        for (BalancaListener elem : this.listeners) {
            elem.onConectado(this);
        }
    }

    private void postEventDisconnect() {
        for (BalancaListener elem : this.listeners) {
            elem.onDesconectado(this);
        }
    }

    private void postEventWeightReceived(int ultimoPeso) {
        this.ultimoPeso = ultimoPeso;
        for (BalancaListener elem : this.listeners) {
            elem.onPesoRecebido(this, ultimoPeso);
        }
    }
}

