/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.idealized;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class Network<AUTHREQUIRED, REQUESTPAUSED> {
    private static final Logger LOG = Logger.getLogger(Network.class.getName());
    private final Map<Predicate<URI>, Supplier<Credentials>> authHandlers = new LinkedHashMap<Predicate<URI>, Supplier<Credentials>>();
    private final Filter defaultFilter;
    private Filter filter = this.defaultFilter = next -> arg_0 -> ((HttpHandler)next).execute(arg_0);
    protected final DevTools devTools;

    public Network(DevTools devtools) {
        this.devTools = (DevTools)Require.nonNull((String)"DevTools", (Object)devtools);
    }

    public void disable() {
        this.devTools.send(this.disableFetch());
        this.devTools.send(this.enableNetworkCaching());
        this.authHandlers.clear();
        this.filter = this.defaultFilter;
    }

    public void setUserAgent(String userAgent) {
        this.devTools.send(this.setUserAgentOverride(new UserAgent(userAgent)));
    }

    public void setUserAgent(UserAgent userAgent) {
        this.devTools.send(this.setUserAgentOverride(userAgent));
    }

    public void addAuthHandler(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        Require.nonNull((String)"URI predicate", whenThisMatches);
        Require.nonNull((String)"Credentials", useTheseCredentials);
        this.authHandlers.put(whenThisMatches, useTheseCredentials);
        this.prepareToInterceptTraffic();
    }

    public void resetNetworkFilter() {
        this.filter = this.defaultFilter;
    }

    public void interceptTrafficWith(Filter filter) {
        Require.nonNull((String)"HTTP filter", (Object)filter);
        this.filter = filter;
        this.prepareToInterceptTraffic();
    }

    public void prepareToInterceptTraffic() {
        this.devTools.send(this.disableNetworkCaching());
        this.devTools.addListener(this.authRequiredEvent(), authRequired -> {
            String origin = this.getUriFrom(authRequired);
            try {
                URI uri = new URI(origin);
                Optional<Credentials> authCredentials = this.getAuthCredentials(uri);
                if (authCredentials.isPresent()) {
                    Credentials credentials = authCredentials.get();
                    if (!(credentials instanceof UsernameAndPassword)) {
                        throw new DevToolsException("DevTools can only support username and password authentication");
                    }
                    UsernameAndPassword uap = (UsernameAndPassword)credentials;
                    this.devTools.send(this.continueWithAuth(authRequired, uap));
                    return;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.devTools.send(this.cancelAuth(authRequired));
        });
        ConcurrentHashMap responses = new ConcurrentHashMap();
        this.devTools.addListener(this.requestPausedEvent(), pausedRequest -> {
            String id = this.getRequestId(pausedRequest);
            Either<HttpRequest, HttpResponse> message = this.createSeMessages(pausedRequest);
            if (message.isRight()) {
                HttpResponse res = (HttpResponse)message.right();
                CompletableFuture future = (CompletableFuture)responses.remove(id);
                if (future == null) {
                    this.devTools.send(this.continueWithoutModification(pausedRequest));
                    return;
                }
                future.complete(res);
                return;
            }
            HttpResponse forBrowser = this.filter.andFinally(req -> {
                CompletableFuture res = new CompletableFuture();
                responses.put(id, res);
                this.devTools.send(this.continueRequest(pausedRequest, req));
                try {
                    return (HttpResponse)res.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WebDriverException((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.log(Level.WARNING, e, () -> "Unable to process request");
                    return new HttpResponse();
                }
            }).execute((HttpRequest)message.left());
            if ("Continue".equals(forBrowser.getHeader("Selenium-Interceptor"))) {
                this.devTools.send(this.continueWithoutModification(pausedRequest));
                return;
            }
            this.devTools.send(this.fulfillRequest(pausedRequest, forBrowser));
        });
        this.devTools.send(this.enableFetchForAllPatterns());
    }

    protected Optional<Credentials> getAuthCredentials(URI uri) {
        Require.nonNull((String)"URI", (Object)uri);
        return this.authHandlers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(uri)).map(Map.Entry::getValue).map(Supplier::get).findFirst();
    }

    protected HttpMethod convertFromCdpHttpMethod(String method) {
        Require.nonNull((String)"HTTP Method", (Object)method);
        try {
            return HttpMethod.valueOf((String)method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.GET;
        }
    }

    protected HttpResponse createHttpResponse(Optional<Integer> statusCode, String body, Boolean bodyIsBase64Encoded, List<Map.Entry<String, String>> headers) {
        Supplier<InputStream> content;
        if (body == null) {
            content = Contents.empty();
        } else if (bodyIsBase64Encoded != null && bodyIsBase64Encoded.booleanValue()) {
            byte[] decoded = Base64.getDecoder().decode(body);
            content = () -> new ByteArrayInputStream(decoded);
        } else {
            content = Contents.string((CharSequence)body, (Charset)StandardCharsets.UTF_8);
        }
        HttpResponse res = (HttpResponse)new HttpResponse().setStatus(statusCode.orElse(200).intValue()).setContent(content);
        headers.forEach(entry -> {
            if (entry.getValue() != null) {
                res.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        return res;
    }

    protected HttpRequest createHttpRequest(String cdpMethod, String url, Map<String, Object> headers, Optional<String> postData) {
        HttpRequest req = new HttpRequest(this.convertFromCdpHttpMethod(cdpMethod), url);
        headers.forEach((key, value) -> req.addHeader(key, String.valueOf(value)));
        postData.ifPresent(data -> req.setContent(Contents.utf8String((CharSequence)data)));
        return req;
    }

    protected abstract Command<Void> setUserAgentOverride(UserAgent var1);

    protected abstract Command<Void> enableNetworkCaching();

    protected abstract Command<Void> disableNetworkCaching();

    protected abstract Command<Void> enableFetchForAllPatterns();

    protected abstract Command<Void> disableFetch();

    protected abstract Event<AUTHREQUIRED> authRequiredEvent();

    protected abstract String getUriFrom(AUTHREQUIRED var1);

    protected abstract Command<Void> continueWithAuth(AUTHREQUIRED var1, UsernameAndPassword var2);

    protected abstract Command<Void> cancelAuth(AUTHREQUIRED var1);

    protected abstract Event<REQUESTPAUSED> requestPausedEvent();

    protected abstract String getRequestId(REQUESTPAUSED var1);

    protected abstract Either<HttpRequest, HttpResponse> createSeMessages(REQUESTPAUSED var1);

    protected abstract Command<Void> continueWithoutModification(REQUESTPAUSED var1);

    protected abstract Command<Void> continueRequest(REQUESTPAUSED var1, HttpRequest var2);

    protected abstract Command<Void> fulfillRequest(REQUESTPAUSED var1, HttpResponse var2);

    public static class UserAgent {
        private final String userAgent;
        private final Optional<String> acceptLanguage;
        private final Optional<String> platform;

        public UserAgent(String userAgent) {
            this(userAgent, Optional.empty(), Optional.empty());
        }

        private UserAgent(String userAgent, Optional<String> acceptLanguage, Optional<String> platform) {
            this.userAgent = userAgent;
            this.acceptLanguage = acceptLanguage;
            this.platform = platform;
        }

        public String userAgent() {
            return this.userAgent;
        }

        public UserAgent acceptLanguage(String acceptLanguage) {
            return new UserAgent(this.userAgent, Optional.of(acceptLanguage), this.platform);
        }

        public Optional<String> acceptLanguage() {
            return this.acceptLanguage;
        }

        public UserAgent platform(String platform) {
            return new UserAgent(this.userAgent, this.acceptLanguage, Optional.of(platform));
        }

        public Optional<String> platform() {
            return this.platform;
        }
    }
}

