/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.AsyncHttpTransportFactory;
import io.sentry.Attachment;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Breadcrumb;
import io.sentry.DataCategory;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.ITransportFactory;
import io.sentry.NoOpTransportFactory;
import io.sentry.ProfilingTraceData;
import io.sentry.RequestDetailsResolver;
import io.sentry.Scope;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.UserFeedback;
import io.sentry.clientreport.DiscardReason;
import io.sentry.exception.SentryEnvelopeException;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.TransactionEnd;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.transport.ITransport;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryClient
implements ISentryClient {
    static final String SENTRY_PROTOCOL_VERSION = "7";
    private boolean enabled;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ITransport transport;
    @Nullable
    private final SecureRandom random;
    @NotNull
    private final SortBreadcrumbsByDate sortBreadcrumbsByDate = new SortBreadcrumbsByDate();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    SentryClient(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.enabled = true;
        ITransportFactory transportFactory = options.getTransportFactory();
        if (transportFactory instanceof NoOpTransportFactory) {
            transportFactory = new AsyncHttpTransportFactory();
            options.setTransportFactory(transportFactory);
        }
        RequestDetailsResolver requestDetailsResolver = new RequestDetailsResolver(options);
        this.transport = transportFactory.create(options, requestDetailsResolver.resolve());
        this.random = options.getSampleRate() == null ? null : new SecureRandom();
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        if (HintUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", event.getEventId());
        return false;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Scope scope, @Nullable Hint hint) {
        ITransaction transaction;
        Throwable eventThrowable;
        Objects.requireNonNull(event, "SentryEvent is required.");
        if (hint == null) {
            hint = new Hint();
        }
        if (this.shouldApplyScopeData(event, hint)) {
            this.addScopeAttachmentsToHint(scope, hint);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (event != null && (eventThrowable = event.getThrowable()) != null && this.options.containsIgnoredExceptionForType(eventThrowable)) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as the exception %s is ignored", eventThrowable.getClass());
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            return SentryId.EMPTY_ID;
        }
        if (this.shouldApplyScopeData(event, hint) && (event = this.applyScope(event, scope, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by applyScope", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        if ((event = this.processEvent(event, hint, this.options.getEventProcessors())) != null && (event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.BEFORE_SEND, DataCategory.Error);
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        Session sessionBeforeUpdate = scope != null ? scope.withSession(session -> {}) : null;
        Session session2 = null;
        if (event != null) {
            session2 = this.updateSessionData(event, hint, scope);
            if (!this.sample()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.SAMPLE_RATE, DataCategory.Error);
                event = null;
            }
        }
        boolean shouldSendSessionUpdate = this.shouldSendSessionUpdateForDroppedEvent(sessionBeforeUpdate, session2);
        if (event == null && !shouldSendSessionUpdate) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Not sending session update for dropped event as it did not cause the session health to change.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        SentryId sentryId = SentryId.EMPTY_ID;
        if (event != null && event.getEventId() != null) {
            sentryId = event.getEventId();
        }
        try {
            TraceContext traceContext = scope != null && scope.getTransaction() != null ? scope.getTransaction().traceContext() : null;
            boolean shouldSendAttachments = event != null;
            List<Attachment> attachments = shouldSendAttachments ? this.getAttachments(hint) : null;
            SentryEnvelope envelope = this.buildEnvelope(event, attachments, session2, traceContext, null);
            hint.clear();
            if (envelope != null) {
                this.transport.send(envelope, hint);
            }
        }
        catch (SentryEnvelopeException | IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing event %s failed.", sentryId);
            sentryId = SentryId.EMPTY_ID;
        }
        if (scope != null && (transaction = scope.getTransaction()) != null && HintUtils.hasType(hint, TransactionEnd.class)) {
            transaction.forceFinish(SpanStatus.ABORTED, false);
        }
        return sentryId;
    }

    private void addScopeAttachmentsToHint(@Nullable Scope scope, @NotNull Hint hint) {
        if (scope != null) {
            hint.addAttachments(scope.getAttachments());
        }
    }

    private boolean shouldSendSessionUpdateForDroppedEvent(@Nullable Session sessionBeforeUpdate, @Nullable Session sessionAfterUpdate) {
        boolean didSessionMoveToErroredState;
        boolean didSessionMoveToCrashedState;
        if (sessionAfterUpdate == null) {
            return false;
        }
        if (sessionBeforeUpdate == null) {
            return true;
        }
        boolean bl = didSessionMoveToCrashedState = sessionAfterUpdate.getStatus() == Session.State.Crashed && sessionBeforeUpdate.getStatus() != Session.State.Crashed;
        if (didSessionMoveToCrashedState) {
            return true;
        }
        boolean bl2 = didSessionMoveToErroredState = sessionAfterUpdate.errorCount() > 0 && sessionBeforeUpdate.errorCount() <= 0;
        return didSessionMoveToErroredState;
    }

    @Nullable
    private List<Attachment> getAttachments(@NotNull Hint hint) {
        Attachment viewHierarchy;
        @NotNull List<Attachment> attachments = hint.getAttachments();
        @Nullable Attachment screenshot = hint.getScreenshot();
        if (screenshot != null) {
            attachments.add(screenshot);
        }
        if ((viewHierarchy = hint.getViewHierarchy()) != null) {
            attachments.add(viewHierarchy);
        }
        return attachments;
    }

    @Nullable
    private SentryEnvelope buildEnvelope(@Nullable SentryBaseEvent event, @Nullable List<Attachment> attachments, @Nullable Session session, @Nullable TraceContext traceContext, @Nullable ProfilingTraceData profilingTraceData) throws IOException, SentryEnvelopeException {
        SentryId sentryId = null;
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        if (event != null) {
            SentryEnvelopeItem eventItem = SentryEnvelopeItem.fromEvent(this.options.getSerializer(), event);
            envelopeItems.add(eventItem);
            sentryId = event.getEventId();
        }
        if (session != null) {
            SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession(this.options.getSerializer(), session);
            envelopeItems.add(sessionItem);
        }
        if (profilingTraceData != null) {
            SentryEnvelopeItem profilingTraceItem = SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, this.options.getMaxTraceFileSize(), this.options.getSerializer());
            envelopeItems.add(profilingTraceItem);
            if (sentryId == null) {
                sentryId = new SentryId(profilingTraceData.getProfileId());
            }
        }
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                SentryEnvelopeItem attachmentItem = SentryEnvelopeItem.fromAttachment(this.options.getSerializer(), this.options.getLogger(), attachment, this.options.getMaxAttachmentSize());
                envelopeItems.add(attachmentItem);
            }
        }
        if (!envelopeItems.isEmpty()) {
            SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(sentryId, this.options.getSdkVersion(), traceContext);
            return new SentryEnvelope(envelopeHeader, envelopeItems);
        }
        return null;
    }

    @Nullable
    private SentryEvent processEvent(@NotNull SentryEvent event, @NotNull Hint hint, @NotNull List<EventProcessor> eventProcessors) {
        for (EventProcessor processor : eventProcessors) {
            try {
                boolean isBackfillingProcessor = processor instanceof BackfillingEventProcessor;
                boolean isBackfillable = HintUtils.hasType(hint, Backfillable.class);
                if (isBackfillable && isBackfillingProcessor) {
                    event = processor.process(event, hint);
                } else if (!isBackfillable && !isBackfillingProcessor) {
                    event = processor.process(event, hint);
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing event by processor: %s", processor.getClass().getName());
            }
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by a processor: %s", processor.getClass().getName());
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Error);
            break;
        }
        return event;
    }

    @Nullable
    private SentryTransaction processTransaction(@NotNull SentryTransaction transaction, @NotNull Hint hint, @NotNull List<EventProcessor> eventProcessors) {
        for (EventProcessor processor : eventProcessors) {
            try {
                transaction = processor.process(transaction, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing transaction by processor: %s", processor.getClass().getName());
            }
            if (transaction != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by a processor: %s", processor.getClass().getName());
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.EVENT_PROCESSOR, DataCategory.Transaction);
            break;
        }
        return transaction;
    }

    @Override
    public void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Objects.requireNonNull(userFeedback, "SentryEvent is required.");
        if (SentryId.EMPTY_ID.equals(userFeedback.getEventId())) {
            this.options.getLogger().log(SentryLevel.WARNING, "Capturing userFeedback without a Sentry Id.", new Object[0]);
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing userFeedback: %s", userFeedback.getEventId());
        try {
            SentryEnvelope envelope = this.buildEnvelope(userFeedback);
            this.transport.send(envelope);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing user feedback %s failed.", userFeedback.getEventId());
        }
    }

    @NotNull
    private SentryEnvelope buildEnvelope(@NotNull UserFeedback userFeedback) {
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        SentryEnvelopeItem userFeedbackItem = SentryEnvelopeItem.fromUserFeedback(this.options.getSerializer(), userFeedback);
        envelopeItems.add(userFeedbackItem);
        SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(userFeedback.getEventId(), this.options.getSdkVersion());
        return new SentryEnvelope(envelopeHeader, envelopeItems);
    }

    @TestOnly
    @Nullable
    Session updateSessionData(@NotNull SentryEvent event, @NotNull Hint hint, @Nullable Scope scope) {
        Session clonedSession = null;
        if (HintUtils.shouldApplyScopeData(hint)) {
            if (scope != null) {
                clonedSession = scope.withSession(session -> {
                    if (session != null) {
                        Session.State status = null;
                        if (event.isCrashed()) {
                            status = Session.State.Crashed;
                        }
                        boolean crashedOrErrored = false;
                        if (Session.State.Crashed == status || event.isErrored()) {
                            crashedOrErrored = true;
                        }
                        String userAgent = null;
                        if (event.getRequest() != null && event.getRequest().getHeaders() != null && event.getRequest().getHeaders().containsKey("user-agent")) {
                            userAgent = event.getRequest().getHeaders().get("user-agent");
                        }
                        Object sentrySdkHint = HintUtils.getSentrySdkHint(hint);
                        String abnormalMechanism = null;
                        if (sentrySdkHint instanceof AbnormalExit) {
                            abnormalMechanism = ((AbnormalExit)sentrySdkHint).mechanism();
                            status = Session.State.Abnormal;
                        }
                        if (session.update(status, userAgent, crashedOrErrored, abnormalMechanism) && HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
                            session.end();
                        }
                    } else {
                        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
                    }
                });
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
            }
        }
        return clonedSession;
    }

    @Override
    @ApiStatus.Internal
    public void captureSession(@NotNull Session session, @Nullable Hint hint) {
        SentryEnvelope envelope;
        Objects.requireNonNull(session, "Session is required.");
        if (session.getRelease() == null || session.getRelease().isEmpty()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Sessions can't be captured without setting a release.", new Object[0]);
            return;
        }
        try {
            envelope = SentryEnvelope.from(this.options.getSerializer(), session, this.options.getSdkVersion());
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture session.", e);
            return;
        }
        this.captureEnvelope(envelope, hint);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Hint hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        if (hint == null) {
            hint = new Hint();
        }
        try {
            hint.clear();
            this.transport.send(envelope, hint);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", e);
            return SentryId.EMPTY_ID;
        }
        SentryId eventId = envelope.getHeader().getEventId();
        if (eventId != null) {
            return eventId;
        }
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Scope scope, @Nullable Hint hint, @Nullable ProfilingTraceData profilingTraceData) {
        Objects.requireNonNull(transaction, "Transaction is required.");
        if (hint == null) {
            hint = new Hint();
        }
        if (this.shouldApplyScopeData(transaction, hint)) {
            this.addScopeAttachmentsToHint(scope, hint);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing transaction: %s", transaction.getEventId());
        SentryId sentryId = SentryId.EMPTY_ID;
        if (transaction.getEventId() != null) {
            sentryId = transaction.getEventId();
        }
        if (this.shouldApplyScopeData(transaction, hint)) {
            if ((transaction = this.applyScope(transaction, scope)) != null && scope != null) {
                transaction = this.processTransaction(transaction, hint, scope.getEventProcessors());
            }
            if (transaction == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by applyScope", new Object[0]);
            }
        }
        if (transaction != null) {
            transaction = this.processTransaction(transaction, hint, this.options.getEventProcessors());
        }
        if (transaction == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by Event processors.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        if ((transaction = this.executeBeforeSendTransaction(transaction, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by beforeSendTransaction.", new Object[0]);
            this.options.getClientReportRecorder().recordLostEvent(DiscardReason.BEFORE_SEND, DataCategory.Transaction);
            return SentryId.EMPTY_ID;
        }
        try {
            SentryEnvelope envelope = this.buildEnvelope(transaction, this.filterForTransaction(this.getAttachments(hint)), null, traceContext, profilingTraceData);
            hint.clear();
            if (envelope != null) {
                this.transport.send(envelope, hint);
            } else {
                sentryId = SentryId.EMPTY_ID;
            }
        }
        catch (SentryEnvelopeException | IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing transaction %s failed.", sentryId);
            sentryId = SentryId.EMPTY_ID;
        }
        return sentryId;
    }

    @Nullable
    private List<Attachment> filterForTransaction(@Nullable List<Attachment> attachments) {
        if (attachments == null) {
            return null;
        }
        ArrayList<Attachment> attachmentsToSend = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            if (!attachment.isAddToTransactions()) continue;
            attachmentsToSend.add(attachment);
        }
        return attachmentsToSend;
    }

    @Nullable
    private SentryEvent applyScope(@NotNull SentryEvent event, @Nullable Scope scope, @NotNull Hint hint) {
        if (scope != null) {
            this.applyScope(event, scope);
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransactionName());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
            ISpan span = scope.getSpan();
            if (event.getContexts().getTrace() == null && span != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            event = this.processEvent(event, hint, scope.getEventProcessors());
        }
        return event;
    }

    @NotNull
    private <T extends SentryBaseEvent> T applyScope(@NotNull T sentryBaseEvent, @Nullable Scope scope) {
        if (scope != null) {
            if (sentryBaseEvent.getRequest() == null) {
                sentryBaseEvent.setRequest(scope.getRequest());
            }
            if (sentryBaseEvent.getUser() == null) {
                sentryBaseEvent.setUser(scope.getUser());
            }
            if (sentryBaseEvent.getTags() == null) {
                sentryBaseEvent.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (sentryBaseEvent.getTags().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (sentryBaseEvent.getBreadcrumbs() == null) {
                sentryBaseEvent.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                this.sortBreadcrumbsByDate(sentryBaseEvent, scope.getBreadcrumbs());
            }
            if (sentryBaseEvent.getExtras() == null) {
                sentryBaseEvent.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (sentryBaseEvent.getExtras().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            Contexts contexts = sentryBaseEvent.getContexts();
            for (Map.Entry entry : new Contexts(scope.getContexts()).entrySet()) {
                if (contexts.containsKey(entry.getKey())) continue;
                contexts.put((String)entry.getKey(), entry.getValue());
            }
        }
        return sentryBaseEvent;
    }

    private void sortBreadcrumbsByDate(@NotNull SentryBaseEvent event, @NotNull Collection<Breadcrumb> breadcrumbs) {
        List<Breadcrumb> sortedBreadcrumbs = event.getBreadcrumbs();
        if (sortedBreadcrumbs != null && !breadcrumbs.isEmpty()) {
            sortedBreadcrumbs.addAll(breadcrumbs);
            Collections.sort(sortedBreadcrumbs, this.sortBreadcrumbsByDate);
        }
    }

    @Nullable
    private SentryEvent executeBeforeSend(@NotNull SentryEvent event, @NotNull Hint hint) {
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                event = beforeSend.execute(event, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", e);
                event = null;
            }
        }
        return event;
    }

    @Nullable
    private SentryTransaction executeBeforeSendTransaction(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        SentryOptions.BeforeSendTransactionCallback beforeSendTransaction = this.options.getBeforeSendTransaction();
        if (beforeSendTransaction != null) {
            try {
                transaction = beforeSendTransaction.execute(transaction, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSendTransaction callback threw an exception. It will be added as breadcrumb and continue.", e);
                transaction = null;
            }
        }
        return transaction;
    }

    @Override
    public void close() {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.flush(this.options.getShutdownTimeoutMillis());
            this.transport.close();
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", e);
        }
        for (EventProcessor eventProcessor : this.options.getEventProcessors()) {
            if (!(eventProcessor instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)eventProcessor)).close();
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the event processor {}.", eventProcessor, e);
            }
        }
        this.enabled = false;
    }

    @Override
    public void flush(long timeoutMillis) {
        this.transport.flush(timeoutMillis);
    }

    private boolean sample() {
        if (this.options.getSampleRate() != null && this.random != null) {
            double sampling = this.options.getSampleRate();
            return !(sampling < this.random.nextDouble());
        }
        return true;
    }

    private static final class SortBreadcrumbsByDate
    implements Comparator<Breadcrumb> {
        private SortBreadcrumbsByDate() {
        }

        @Override
        public int compare(@NotNull Breadcrumb b1, @NotNull Breadcrumb b2) {
            return b1.getTimestamp().compareTo(b2.getTimestamp());
        }
    }
}

