/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Baggage;
import io.sentry.Instrumenter;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransactionContext
extends SpanContext {
    @NotNull
    private final String name;
    @NotNull
    private final TransactionNameSource transactionNameSource;
    @Nullable
    private TracesSamplingDecision parentSamplingDecision;
    @Nullable
    private Baggage baggage;
    @NotNull
    private Instrumenter instrumenter = Instrumenter.SENTRY;

    @NotNull
    public static TransactionContext fromSentryTrace(@NotNull String name, @NotNull String operation, @NotNull SentryTraceHeader sentryTrace) {
        return TransactionContext.fromSentryTrace(name, TransactionNameSource.CUSTOM, operation, sentryTrace, null, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static TransactionContext fromSentryTrace(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation, @NotNull SentryTraceHeader sentryTrace) {
        @Nullable Boolean parentSampled = sentryTrace.isSampled();
        return new TransactionContext(name, operation, sentryTrace.getTraceId(), new SpanId(), transactionNameSource, sentryTrace.getSpanId(), parentSampled == null ? null : new TracesSamplingDecision(parentSampled), null);
    }

    @ApiStatus.Internal
    @NotNull
    public static TransactionContext fromSentryTrace(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation, @NotNull SentryTraceHeader sentryTrace, @Nullable Baggage baggage, @Nullable SpanId spanId) {
        TracesSamplingDecision samplingDecision;
        @Nullable Boolean parentSampled = sentryTrace.isSampled();
        TracesSamplingDecision tracesSamplingDecision = samplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
        if (baggage != null) {
            baggage.freeze();
            Double sampleRate = baggage.getSampleRateDouble();
            Boolean sampled = parentSampled != null ? parentSampled : true;
            samplingDecision = sampleRate != null ? new TracesSamplingDecision(sampled, sampleRate) : new TracesSamplingDecision(sampled);
        }
        @NotNull SpanId spanIdToUse = spanId == null ? new SpanId() : spanId;
        return new TransactionContext(name, operation, sentryTrace.getTraceId(), spanIdToUse, transactionNameSource, sentryTrace.getSpanId(), samplingDecision, baggage);
    }

    public TransactionContext(@NotNull String name, @NotNull String operation) {
        this(name, operation, null);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation) {
        this(name, transactionNameSource, operation, null);
    }

    public TransactionContext(@NotNull String name, @NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        this(name, TransactionNameSource.CUSTOM, operation, samplingDecision);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        super(operation);
        this.name = Objects.requireNonNull(name, "name is required");
        this.transactionNameSource = transactionNameSource;
        this.setSamplingDecision(samplingDecision);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull String name, @NotNull String operation, @NotNull SentryId traceId, @NotNull SpanId spanId, @NotNull TransactionNameSource transactionNameSource, @Nullable SpanId parentSpanId, @Nullable TracesSamplingDecision parentSamplingDecision, @Nullable Baggage baggage) {
        super(traceId, spanId, operation, parentSpanId, null);
        this.name = Objects.requireNonNull(name, "name is required");
        this.parentSamplingDecision = parentSamplingDecision;
        this.transactionNameSource = transactionNameSource;
        this.baggage = baggage;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getParentSampled() {
        if (this.parentSamplingDecision == null) {
            return null;
        }
        return this.parentSamplingDecision.getSampled();
    }

    @Nullable
    public TracesSamplingDecision getParentSamplingDecision() {
        return this.parentSamplingDecision;
    }

    @Nullable
    public Baggage getBaggage() {
        return this.baggage;
    }

    public void setParentSampled(@Nullable Boolean parentSampled) {
        this.parentSamplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
    }

    public void setParentSampled(@Nullable Boolean parentSampled, @Nullable Boolean parentProfileSampled) {
        this.parentSamplingDecision = parentSampled == null ? null : (parentProfileSampled == null ? new TracesSamplingDecision(parentSampled) : new TracesSamplingDecision(parentSampled, null, parentProfileSampled, null));
    }

    @NotNull
    public TransactionNameSource getTransactionNameSource() {
        return this.transactionNameSource;
    }

    @NotNull
    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public void setInstrumenter(@NotNull Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }
}

