/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.soulwing.ssl.ConcreteKeyStoreSubBuilder;
import org.soulwing.ssl.KeyStoreSubBuilder;
import org.soulwing.ssl.SSLContextBuilder;
import org.soulwing.ssl.SSLContextWrapper;
import org.soulwing.ssl.SSLParametersConfiguration;
import org.soulwing.ssl.SSLRuntimeException;

class ConcreteSSLContextBuilder
implements SSLContextBuilder {
    private final SSLParametersConfiguration parameters = new SSLParametersConfiguration();
    private String protocol = "TLS";
    private String providerName;
    private Provider provider;
    private KeyStore keyStore;
    private char[] keyPassword;
    private KeyStore trustStore;
    private SecureRandom secureRandom;

    ConcreteSSLContextBuilder() {
    }

    @Override
    public SSLContextBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public SSLContextBuilder provider(String providerName) {
        this.providerName = providerName;
        return this;
    }

    @Override
    public SSLContextBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public SSLContextBuilder excludeProtocol(String protocol) {
        this.parameters.excludeProtocols(protocol);
        return this;
    }

    @Override
    public SSLContextBuilder excludeProtocols(String ... protocols) {
        this.parameters.excludeProtocols(protocols);
        return this;
    }

    @Override
    public SSLContextBuilder includeProtocol(String protocol) {
        this.parameters.includeProtocols(protocol);
        return this;
    }

    @Override
    public SSLContextBuilder includeProtocols(String ... protocols) {
        this.parameters.includeProtocols(protocols);
        return this;
    }

    @Override
    public SSLContextBuilder excludeCipherSuite(String cipherSuite) {
        this.parameters.excludeCipherSuites(cipherSuite);
        return this;
    }

    @Override
    public SSLContextBuilder excludeCipherSuites(String ... cipherSuites) {
        this.parameters.excludeCipherSuites(cipherSuites);
        return this;
    }

    @Override
    public SSLContextBuilder includeCipherSuite(String cipherSuite) {
        this.parameters.includeCipherSuites(cipherSuite);
        return this;
    }

    @Override
    public SSLContextBuilder includeCipherSuites(String ... cipherSuites) {
        this.parameters.includeCipherSuites(cipherSuites);
        return this;
    }

    @Override
    public SSLContextBuilder clientAuthentication(SSLContextBuilder.ClientAuthentication type) {
        switch (type) {
            case NONE: {
                this.parameters.setWantClientAuth(false);
                this.parameters.setNeedClientAuth(false);
                break;
            }
            case REQUESTED: {
                this.parameters.setWantClientAuth(true);
                this.parameters.setNeedClientAuth(false);
                break;
            }
            case REQUIRED: {
                this.parameters.setWantClientAuth(true);
                this.parameters.setNeedClientAuth(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized client authentication type");
            }
        }
        return this;
    }

    @Override
    public SSLContextBuilder credential(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.keyPassword = password;
        return this;
    }

    @Override
    public SSLContextBuilder credential(KeyStore keyStore, String password) {
        return this.credential(keyStore, password != null ? password.toCharArray() : null);
    }

    @Override
    public KeyStoreSubBuilder credential() {
        return new ConcreteKeyStoreSubBuilder(new ConcreteKeyStoreSubBuilder.EndHandler(){

            @Override
            public SSLContextBuilder handleEnd(KeyStore keyStore, char[] password) {
                ConcreteSSLContextBuilder.this.keyStore = keyStore;
                ConcreteSSLContextBuilder.access$102(ConcreteSSLContextBuilder.this, password);
                return ConcreteSSLContextBuilder.this;
            }
        });
    }

    @Override
    public KeyStoreSubBuilder credential(char[] keyPassword) {
        this.keyPassword = keyPassword;
        return new ConcreteKeyStoreSubBuilder(new ConcreteKeyStoreSubBuilder.EndHandler(){

            @Override
            public SSLContextBuilder handleEnd(KeyStore keyStore, char[] password) {
                ConcreteSSLContextBuilder.this.keyStore = keyStore;
                return ConcreteSSLContextBuilder.this;
            }
        });
    }

    @Override
    public KeyStoreSubBuilder credential(String keyPassword) {
        return this.credential(keyPassword != null ? keyPassword.toCharArray() : null);
    }

    @Override
    public SSLContextBuilder peerTrust(KeyStore trustStore) {
        this.trustStore = trustStore;
        return null;
    }

    @Override
    public KeyStoreSubBuilder peerTrust() {
        return new ConcreteKeyStoreSubBuilder(new ConcreteKeyStoreSubBuilder.EndHandler(){

            @Override
            public SSLContextBuilder handleEnd(KeyStore trustStore, char[] password) {
                ConcreteSSLContextBuilder.this.trustStore = trustStore;
                return ConcreteSSLContextBuilder.this;
            }
        });
    }

    @Override
    public SSLContextBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    @Override
    public SSLContext build() throws SSLRuntimeException {
        try {
            SSLContext context = this.newSSLContext();
            SSLContextWrapper wrapper = new SSLContextWrapper(context, this.parameters);
            wrapper.init(this.createKeyManagers(), this.createTrustManagers(), this.secureRandom);
            return wrapper;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SSLRuntimeException(ex);
        }
    }

    private SSLContext newSSLContext() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.protocol == null) {
            throw new SSLRuntimeException("protocol is required");
        }
        if (this.provider != null) {
            return SSLContext.getInstance(this.protocol, this.provider);
        }
        if (this.providerName != null) {
            return SSLContext.getInstance(this.protocol, this.providerName);
        }
        return SSLContext.getInstance(this.protocol);
    }

    private KeyManager[] createKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        if (this.keyStore == null) {
            return null;
        }
        if (this.keyPassword == null) {
            throw new SSLRuntimeException("key password is required");
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.keyStore, this.keyPassword);
        return kmf.getKeyManagers();
    }

    private TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        if (this.trustStore == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.trustStore);
        return tmf.getTrustManagers();
    }

    static /* synthetic */ char[] access$102(ConcreteSSLContextBuilder x0, char[] x1) {
        x0.keyPassword = x1;
        return x1;
    }
}

