/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.logging;

import org.webbitserver.EventSourceConnection;
import org.webbitserver.EventSourceHandler;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.handler.logging.LogSink;
import org.webbitserver.handler.logging.LoggingEventSourceConnection;
import org.webbitserver.handler.logging.LoggingEventSourceHandler;
import org.webbitserver.handler.logging.LoggingWebSocketConnection;
import org.webbitserver.handler.logging.LoggingWebSocketHandler;
import org.webbitserver.wrapper.HttpControlWrapper;
import org.webbitserver.wrapper.HttpResponseWrapper;

public class LoggingHandler
implements HttpHandler {
    private final LogSink logSink;

    public LoggingHandler(LogSink logSink) {
        this.logSink = logSink;
    }

    public LogSink logSink() {
        return this.logSink;
    }

    @Override
    public void handleHttpRequest(final HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        this.logSink.httpStart(request);
        HttpResponseWrapper responseWrapper = new HttpResponseWrapper(response){

            @Override
            public HttpResponseWrapper end() {
                LoggingHandler.this.logSink.httpEnd(request);
                return super.end();
            }

            @Override
            public HttpResponseWrapper error(Throwable error) {
                LoggingHandler.this.logSink.httpEnd(request);
                LoggingHandler.this.logSink.error(request, error);
                return super.error(error);
            }
        };
        HttpControlWrapper controlWrapper = new HttpControlWrapper(control){
            private LoggingWebSocketConnection loggingWebSocketConnection;
            private LoggingEventSourceConnection loggingEventSourceConnection;

            @Override
            public WebSocketConnection webSocketConnection() {
                return this.loggingWebSocketConnection;
            }

            @Override
            public WebSocketConnection upgradeToWebSocketConnection(WebSocketHandler handler) {
                this.loggingWebSocketConnection = new LoggingWebSocketConnection(LoggingHandler.this.logSink, super.webSocketConnection());
                return super.upgradeToWebSocketConnection(new LoggingWebSocketHandler(LoggingHandler.this.logSink, this.loggingWebSocketConnection, handler));
            }

            @Override
            public EventSourceConnection eventSourceConnection() {
                return this.loggingEventSourceConnection;
            }

            @Override
            public EventSourceConnection upgradeToEventSourceConnection(EventSourceHandler handler) {
                this.loggingEventSourceConnection = new LoggingEventSourceConnection(LoggingHandler.this.logSink, super.eventSourceConnection());
                return super.upgradeToEventSourceConnection(new LoggingEventSourceHandler(LoggingHandler.this.logSink, this.loggingEventSourceConnection, handler));
            }
        };
        control.nextHandler(request, responseWrapper, controlWrapper);
    }
}

