/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal;

import java.util.Arrays;
import java.util.List;

public enum DFModelo {
    AVULSA("01", "Nota avulsa"),
    PRODUTOR("04", "Nota produtor"),
    NFE("55", "NF-e"),
    NFCE("65", "NFC-e"),
    CTE("57", "CT-e"),
    MDFE("58", "MDF-e"),
    CFE("59", "CF-e"),
    CTeOS("67", "CT-e OS");

    public static final List<DFModelo> MODELOS_NOTAS_NAO_ELETRONICAS;
    private final String codigo;
    private final String descricao;

    private DFModelo(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static DFModelo valueOfCodigo(String codigo) {
        for (DFModelo tipo : DFModelo.values()) {
            if (!tipo.getCodigo().equals(codigo)) continue;
            return tipo;
        }
        return null;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    static {
        MODELOS_NOTAS_NAO_ELETRONICAS = Arrays.asList(AVULSA, PRODUTOR);
    }
}

