/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte.webservices.distribuicao;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoConsultaNSU;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoInt;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoNSU;
import com.fincatto.documentofiscal.cte.webservices.distribuicao.CTeDistribuicaoDFeSoapStub;
import com.fincatto.documentofiscal.cte200.classes.CTAutorizador;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang3.StringUtils;

public class WSDistribuicaoCTe {
    private final CTeConfig config;

    public WSDistribuicaoCTe(CTeConfig config) {
        this.config = config;
    }

    @Deprecated
    public static String consultar(CTDistribuicaoInt distDFeInt, NFeConfig config) throws Exception {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(config), 443));
        try {
            OMElement ome = AXIOMUtil.stringToOM((String)distDFeInt.toString());
            CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0 dadosMsgType0 = new CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0();
            dadosMsgType0.setExtraElement(ome);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse distDFeInteresse = new CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse();
            distDFeInteresse.setCteDadosMsg(dadosMsgType0);
            CTeDistribuicaoDFeSoapStub stub = new CTeDistribuicaoDFeSoapStub(CTAutorizador.AN.getDistribuicaoDFe(config.getAmbiente()), config);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresseResponse result = stub.cteDistDFeInteresse(distDFeInteresse);
            return result.getCteDistDFeInteresseResult().getExtraElement().toString();
        }
        catch (RemoteException | XMLStreamException e) {
            throw new Exception(e.getMessage());
        }
    }

    public CTDistribuicaoIntRetorno consultar(String cpfOuCnpj, DFUnidadeFederativa uf, String nsu, String ultNsu) throws Exception {
        try {
            String xmlEnvio = this.gerarCTeDistribuicaoInt(cpfOuCnpj, uf, nsu, ultNsu).toString();
            DFXMLValidador.validaDistribuicaoCTe(xmlEnvio);
            OMElement ome = AXIOMUtil.stringToOM((String)xmlEnvio);
            CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0 dadosMsgType0 = new CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0();
            dadosMsgType0.setExtraElement(ome);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse distDFeInteresse = new CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse();
            distDFeInteresse.setCteDadosMsg(dadosMsgType0);
            CTeDistribuicaoDFeSoapStub stub = new CTeDistribuicaoDFeSoapStub(CTAutorizador.AN.getDistribuicaoDFe(this.config.getAmbiente()), this.config);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresseResponse result = stub.cteDistDFeInteresse(distDFeInteresse);
            return (CTDistribuicaoIntRetorno)this.config.getPersister().read(CTDistribuicaoIntRetorno.class, result.getCteDistDFeInteresseResult().getExtraElement().toString());
        }
        catch (RemoteException | XMLStreamException e) {
            throw new Exception(e.getMessage());
        }
    }

    private CTDistribuicaoInt gerarCTeDistribuicaoInt(String cpfOuCnpj, DFUnidadeFederativa uf, String nsu, String ultNsu) {
        CTDistribuicaoInt distDFeInt = new CTDistribuicaoInt();
        distDFeInt.setVersao("1.00");
        distDFeInt.setAmbiente(this.config.getAmbiente());
        distDFeInt.setUnidadeFederativaAutor(uf);
        if (cpfOuCnpj.length() == 11) {
            distDFeInt.setCpf(cpfOuCnpj);
        } else {
            distDFeInt.setCnpj(cpfOuCnpj);
        }
        if (StringUtils.isNotBlank((CharSequence)ultNsu)) {
            distDFeInt.setDistribuicao(new CTDistribuicaoNSU().setUltimoNSU(ultNsu));
        } else {
            distDFeInt.setConsulta(new CTDistribuicaoConsultaNSU().setNsu(nsu));
        }
        return distDFeInt;
    }

    public static String decodeGZipToXml(String conteudoEncode) throws Exception {
        if (conteudoEncode == null || conteudoEncode.length() == 0) {
            return "";
        }
        byte[] conteudo = Base64.getDecoder().decode(conteudoEncode);
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));){
            String string;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));){
                String line;
                StringBuilder outStr = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    outStr.append(line);
                }
                string = outStr.toString();
            }
            return string;
        }
    }
}

