/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte200.classes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum CTTomadorServico {
    REMETENTE("0", "Remetente"),
    EXPEDIDOR("1", "Expedidor"),
    RECEBEDOR("2", "Recebedor"),
    DESTINATARIO("3", "Destinata\u0301rio"),
    OUTROS("4", "Outros");

    public static final List<CTTomadorServico> TOMADOR_3;
    public static final List<CTTomadorServico> TOMADOR_4;
    private final String codigo;
    private final String descricao;

    private CTTomadorServico(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static CTTomadorServico valueOfCodigo(String codigo) {
        for (CTTomadorServico formaPagamento : CTTomadorServico.values()) {
            if (!formaPagamento.getCodigo().equals(codigo)) continue;
            return formaPagamento;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    static {
        TOMADOR_3 = Arrays.asList(REMETENTE, EXPEDIDOR, RECEBEDOR, DESTINATARIO);
        TOMADOR_4 = Collections.singletonList(OUTROS);
    }
}

