/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFPais;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;

public class CTeNotaEndereco
extends DFBase {
    private static final long serialVersionUID = 1528514404620728196L;
    @Element(name="xLgr")
    private String logradouro = null;
    @Element(name="nro")
    private String numero = null;
    @Element(name="xCpl", required=false)
    private String complemento = null;
    @Element(name="xBairro")
    private String bairro = null;
    @Element(name="cMun")
    private String codigoMunicipio = null;
    @Element(name="xMun")
    private String descricaoMunicipio = null;
    @Element(name="CEP", required=false)
    private String cep = null;
    @Element(name="UF")
    private String siglaUF = null;
    @Element(name="cPais", required=false)
    private DFPais codigoPais = null;
    @Element(name="xPais", required=false)
    private String descricaoPais = null;

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        DFStringValidador.tamanho2ate60(logradouro, "Logradouro");
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        DFStringValidador.tamanho60(numero, "N\u00famero");
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        DFStringValidador.tamanho60(complemento, "Complemento");
        this.complemento = complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        DFStringValidador.tamanho2ate60(bairro, "Bairro");
        this.bairro = bairro;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public void setCodigoMunicipio(String codigoMunicipio) {
        DFStringValidador.exatamente7N(codigoMunicipio, "C\u00f3digo do munic\u00edpio");
        this.codigoMunicipio = codigoMunicipio;
    }

    public String getDescricaoMunicipio() {
        return this.descricaoMunicipio;
    }

    public void setDescricaoMunicipio(String descricaoMunicipio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipio, "Nome do munic\u00edpio");
        this.descricaoMunicipio = descricaoMunicipio;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        DFStringValidador.exatamente8N(cep, "CEP");
        this.cep = cep;
    }

    public String getSiglaUF() {
        return this.siglaUF;
    }

    public void setSiglaUF(String siglaUf) {
        DFStringValidador.exatamente2(siglaUf, "Sigla da UF");
        this.siglaUF = siglaUf;
    }

    public DFPais getCodigoPais() {
        return this.codigoPais;
    }

    public void setCodigoPais(String codigoPais) {
        DFStringValidador.tamanho4N(codigoPais, "C\u00f3digo do pa\u00eds");
        this.codigoPais = DFPais.valueOfCodigo(codigoPais);
    }

    public String getDescricaoPais() {
        return this.descricaoPais;
    }

    public void setDescricaoPais(String descricaoPais) {
        DFStringValidador.tamanho2ate60(descricaoPais, "Nome do pa\u00eds");
        this.descricaoPais = descricaoPais;
    }
}

