/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="fat")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalCobrancaFatura
extends DFBase {
    private static final long serialVersionUID = -1932996967635387615L;
    @Element(name="nFat", required=false)
    private String numero = null;
    @Element(name="vOrig", required=false)
    private String valorOriginal = null;
    @Element(name="vDesc", required=false)
    private String valorDesconto = null;
    @Element(name="vLiq", required=false)
    private String valorLiquido = null;

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        DFStringValidador.tamanho60(numero, "N\u00famero da fatura");
        this.numero = numero;
    }

    public String getValorOriginal() {
        return this.valorOriginal;
    }

    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorOriginal, "Valor original da fatura");
    }

    public String getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorDesconto, "Valor do desconto da fatura");
    }

    public String getValorLiquido() {
        return this.valorLiquido;
    }

    public void setValorLiquido(BigDecimal valorLiquido) {
        this.valorLiquido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorLiquido, "Valor l\u00edquido da fatura");
    }
}

