/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infCarga")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoCarga
extends DFBase {
    private static final long serialVersionUID = -2031819416191957758L;
    @Element(name="vCarga", required=false)
    private String valorTotalCarga = null;
    @Element(name="proPred", required=false)
    private String descricaoProdutoPredominante = null;
    @Element(name="xOutCat", required=false)
    private String descricaoOutrasCaracteristicas = null;
    @ElementList(name="infQ", inline=true)
    private List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> informacoesQuantidadeCarga = null;
    @Element(name="vCargaAverb", required=false)
    private String valorAverbacao = null;

    public String getValorTotalCarga() {
        return this.valorTotalCarga;
    }

    public void setValorTotalCarga(BigDecimal valorTotalCarga) {
        this.valorTotalCarga = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalCarga, "Valor total da carga");
    }

    public String getDescricaoProdutoPredominante() {
        return this.descricaoProdutoPredominante;
    }

    public void setDescricaoProdutoPredominante(String descricaoProdutoPredominante) {
        DFStringValidador.tamanho60(descricaoProdutoPredominante, "Produto predominante");
        this.descricaoProdutoPredominante = descricaoProdutoPredominante;
    }

    public String getDescricaoOutrasCaracteristicas() {
        return this.descricaoOutrasCaracteristicas;
    }

    public void setDescricaoOutrasCaracteristicas(String descricaoOutrasCaracteristicas) {
        DFStringValidador.tamanho30(descricaoOutrasCaracteristicas, "Outras caracter\u00edsticas da carga");
        this.descricaoOutrasCaracteristicas = descricaoOutrasCaracteristicas;
    }

    public List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> getInformacoesQuantidadeCarga() {
        return this.informacoesQuantidadeCarga;
    }

    public void setInformacoesQuantidadeCarga(List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> informacoesQuantidadeCarga) {
        this.informacoesQuantidadeCarga = informacoesQuantidadeCarga;
    }

    public String getValorAverbacao() {
        return this.valorAverbacao;
    }

    public void setValorAverbacao(BigDecimal valorAverbacao) {
        this.valorAverbacao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorAverbacao, "Valor da Carga para efeito de averba\u00e7\u00e3o");
    }
}

