/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosLacre;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infUnidCarga")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga
extends DFBase {
    private static final long serialVersionUID = -3462616457147475669L;
    @Element(name="tpUnidCarga")
    private String unidadeCarga = null;
    @Element(name="idUnidCarga")
    private String identificacaoCarga = null;
    @ElementList(name="lacUnidCarga", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosLacre> lacre = null;
    @Element(name="qtdRat", required=false)
    private String quantidadeRateada = null;

    public String getUnidadeCarga() {
        return this.unidadeCarga;
    }

    public void setUnidadeCarga(String unidadeCarga) {
        this.unidadeCarga = unidadeCarga;
    }

    public String getIdentificacaoCarga() {
        return this.identificacaoCarga;
    }

    public void setIdentificacaoCarga(String identificacaoCarga) {
        DFStringValidador.tamanho20(identificacaoCarga, "Identifica\u00e7\u00e3o da Unidade de Carga");
        this.identificacaoCarga = identificacaoCarga;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosLacre> getLacre() {
        return this.lacre;
    }

    public void setLacre(List<CTeNotaInfoCTeNormalInfoDocumentosLacre> lacre) {
        this.lacre = lacre;
    }

    public String getQuantidadeRateada() {
        return this.quantidadeRateada;
    }

    public void setQuantidadeRateada(BigDecimal quantidadeRateada) {
        this.quantidadeRateada = DFBigDecimalValidador.tamanho5Com2CasasDecimais(quantidadeRateada, "Quantidade rateada (Peso,Volume)");
    }
}

