/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="dest")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoDestinatario
extends DFBase {
    private static final long serialVersionUID = 2313824611520451190L;
    @Element(name="CNPJ", required=false)
    private String cnpj = null;
    @Element(name="CPF", required=false)
    private String cpf = null;
    @Element(name="IE", required=false)
    private String inscricaoEstadual = null;
    @Element(name="xNome")
    private String razaoSocial = null;
    @Element(name="fone", required=false)
    private String telefone = null;
    @Element(name="ISUF", required=false)
    private String inscricaoSuframa = null;
    @Element(name="enderDest")
    private CTeNotaEndereco endereco = null;
    @Element(name="email", required=false)
    private String email = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        DFStringValidador.cpf(cpf);
        this.cpf = cpf;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        DFStringValidador.inscricaoEstadual(inscricaoEstadual);
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        DFStringValidador.tamanho2ate60(razaoSocial, "Raz\u00e3o Social ou Nome do destinat\u00e1rio");
        this.razaoSocial = razaoSocial;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        DFStringValidador.telefone(telefone);
        this.telefone = telefone;
    }

    public String getInscricaoSuframa() {
        return this.inscricaoSuframa;
    }

    public void setInscricaoSuframa(String inscricaoSuframa) {
        DFStringValidador.tamanho8a9N(inscricaoSuframa, "Inscri\u00e7\u00e3o na SUFRAMA");
        this.inscricaoSuframa = inscricaoSuframa;
    }

    public CTeNotaEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(CTeNotaEndereco endereco) {
        this.endereco = endereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        DFStringValidador.tamanho60(email, "Endere\u00e7o de email");
        DFStringValidador.email(email);
        this.email = email;
    }
}

