/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaEnderecoEmitente;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoEmitente
extends DFBase {
    private static final long serialVersionUID = -316869143177543788L;
    @Element(name="CNPJ")
    private String cnpj = null;
    @Element(name="IE")
    private String inscricaoEstadual = null;
    @Element(name="IEST", required=false)
    private String inscricaoEstadualST = null;
    @Element(name="xNome")
    private String razaoSocial = null;
    @Element(name="xFant", required=false)
    private String nomeFantasia = null;
    @Element(name="enderEmit")
    private CTeNotaEnderecoEmitente endereco = null;
    @Element(name="CRT", required=false)
    private String tipoRegimeTributario = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        DFStringValidador.inscricaoEstadualSemIsencao(inscricaoEstadual);
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getInscricaoEstadualST() {
        return this.inscricaoEstadualST;
    }

    public void setInscricaoEstadualST(String inscricaoEstadualST) {
        DFStringValidador.tamanho14N(inscricaoEstadualST, "Inscri\u00e7\u00e3o Estadual do Substituto Tribut\u00e1rio");
        this.inscricaoEstadualST = inscricaoEstadualST;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String xNome) {
        DFStringValidador.tamanho2ate60(xNome, "Raz\u00e3o social ou Nome do emitente");
        this.razaoSocial = xNome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String xFant) {
        DFStringValidador.tamanho2ate60(xFant, "Nome fantasia");
        this.nomeFantasia = xFant;
    }

    public CTeNotaEnderecoEmitente getEnderEmit() {
        return this.endereco;
    }

    public void setEnderEmit(CTeNotaEnderecoEmitente enderEmit) {
        this.endereco = enderEmit;
    }

    public String getTipoRegimeTributario() {
        return this.tipoRegimeTributario;
    }

    public CTeNotaInfoEmitente setTipoRegimeTributario(String tipoRegimeTributario) {
        this.tipoRegimeTributario = tipoRegimeTributario;
        return this;
    }
}

