/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte300.classes.CTFinalidade;
import com.fincatto.documentofiscal.cte300.classes.CTIndicadorTomador;
import com.fincatto.documentofiscal.cte300.classes.CTModal;
import com.fincatto.documentofiscal.cte300.classes.CTProcessoEmissao;
import com.fincatto.documentofiscal.cte300.classes.CTRetirada;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoIdentificacaoTomadorServico3;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoIdentificacaoTomadorServico4;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = 95577143198511960L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF = null;
    @Element(name="cCT")
    private String codigoNumerico = null;
    @Element(name="CFOP")
    private String cfop = null;
    @Element(name="natOp")
    private String naturezaOperacao = null;
    @Element(name="mod")
    private DFModelo modelo = null;
    @Element(name="serie")
    private Integer serie = null;
    @Element(name="nCT")
    private Integer numero = null;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao = null;
    @Element(name="tpImp")
    private String tipoImpressao = null;
    @Element(name="tpEmis")
    private String tipoEmissao = null;
    @Element(name="cDV")
    private Integer digitoVerificador = null;
    @Element(name="tpAmb")
    private DFAmbiente ambiente = null;
    @Element(name="tpCTe")
    private CTFinalidade finalidade = null;
    @Element(name="procEmi")
    private CTProcessoEmissao processoEmissao = null;
    @Element(name="verProc")
    private String versaoProcessoEmissao = null;
    @Element(name="indGlobalizado", required=false)
    private Integer indicadorGlobalizado = null;
    @Element(name="cMunEnv")
    private String codigoMunicipioEnvio = null;
    @Element(name="xMunEnv")
    private String descricaoMunicipioEnvio = null;
    @Element(name="UFEnv")
    private String siglaUFEnvio = null;
    @Element(name="modal")
    private CTModal modalidadeFrete = null;
    @Element(name="tpServ")
    private String tipoServico = null;
    @Element(name="cMunIni")
    private String codigoMunicipioInicio = null;
    @Element(name="xMunIni")
    private String descricaoMunicipioInicio = null;
    @Element(name="UFIni")
    private String siglaUfInicio = null;
    @Element(name="cMunFim")
    private String codigoMunicipioFim = null;
    @Element(name="xMunFim")
    private String descricaoMunicipioFim = null;
    @Element(name="UFFim")
    private String siglaUfFim = null;
    @Element(name="retira")
    private CTRetirada retira = null;
    @Element(name="xDetRetira", required=false)
    private String detalheRetira = null;
    @Element(name="indIEToma")
    private CTIndicadorTomador indIEToma = null;
    @Element(name="toma3", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico3 tomadorServico3 = null;
    @Element(name="toma4", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico4 tomadorServico4 = null;
    @Element(name="dhCont", required=false)
    private LocalDateTime dataContingencia = null;
    @Element(name="xJust", required=false)
    private String justificativa = null;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa codigoUF) {
        this.codigoUF = codigoUF;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String codigoNumerico) {
        DFStringValidador.exatamente8N(codigoNumerico, "Codigo Numerico");
        this.codigoNumerico = codigoNumerico;
    }

    public String getCfop() {
        return this.cfop;
    }

    public void setCfop(String cfop) {
        DFStringValidador.exatamente4N(cfop, "CFOP");
        this.cfop = cfop;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(String naturezaOperacao) {
        DFStringValidador.tamanho2ate60(naturezaOperacao, "Natureza da Operacao");
        this.naturezaOperacao = naturezaOperacao;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public void setModelo(DFModelo modelo) {
        this.modelo = modelo;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer serie) {
        DFIntegerValidador.tamanho3(serie, "Serie");
        this.serie = serie;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        DFIntegerValidador.tamanho9(numero, "Numero");
        this.numero = numero;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getTipoImpressao() {
        return this.tipoImpressao;
    }

    public void setTipoImpressao(String tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }

    public String getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(String tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        DFIntegerValidador.exatamente1(digitoVerificador, "DV");
        this.digitoVerificador = digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public CTFinalidade getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(CTFinalidade finalidade) {
        this.finalidade = finalidade;
    }

    public CTProcessoEmissao getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(CTProcessoEmissao processoEmissao) {
        this.processoEmissao = processoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String versaoProcessoEmissao) {
        DFStringValidador.tamanho20(versaoProcessoEmissao, "Versao Aplicativo Emissor");
        this.versaoProcessoEmissao = versaoProcessoEmissao;
    }

    public Integer getIndicadorGlobalizado() {
        return this.indicadorGlobalizado;
    }

    public void setIndicadorGlobalizado(Integer indicadorGlobalizado) {
        DFIntegerValidador.exatamente1(indicadorGlobalizado, "Indicador de CT-e Globalizado");
        this.indicadorGlobalizado = indicadorGlobalizado;
    }

    public String getCodigoMunicipioEnvio() {
        return this.codigoMunicipioEnvio;
    }

    public void setCodigoMunicipioEnvio(String codigoMunicipioEnvio) {
        DFStringValidador.exatamente7N(codigoMunicipioEnvio, "Codigo do Municipio de envio do CT-e");
        this.codigoMunicipioEnvio = codigoMunicipioEnvio;
    }

    public String getDescricaoMunicipioEnvio() {
        return this.descricaoMunicipioEnvio;
    }

    public void setDescricaoMunicipioEnvio(String descricaoMunicipioEnvio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioEnvio, "Nome do Municipio de envio do CT-e");
        this.descricaoMunicipioEnvio = descricaoMunicipioEnvio;
    }

    public String getSiglaUFEnvio() {
        return this.siglaUFEnvio;
    }

    public void setSiglaUFEnvio(String siglaUFEnvio) {
        DFStringValidador.exatamente2(siglaUFEnvio, "Sigla da UF de envio do CT-e");
        this.siglaUFEnvio = siglaUFEnvio;
    }

    public CTModal getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(CTModal modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public String getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(String tipoServico) {
        this.tipoServico = tipoServico;
    }

    public String getCodigoMunicipioInicio() {
        return this.codigoMunicipioInicio;
    }

    public void setCodigoMunicipioInicio(String codigoMunicipioInicio) {
        DFStringValidador.exatamente7N(codigoMunicipioInicio, "Codigo do Municipio de inicio da prestacao");
        this.codigoMunicipioInicio = codigoMunicipioInicio;
    }

    public String getDescricaoMunicipioInicio() {
        return this.descricaoMunicipioInicio;
    }

    public void setDescricaoMunicipioInicio(String descricaoMunicipioInicio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioInicio, "Nome do Municipio do inicio da prestacao");
        this.descricaoMunicipioInicio = descricaoMunicipioInicio;
    }

    public String getSiglaUfInicio() {
        return this.siglaUfInicio;
    }

    public void setSiglaUfInicio(String siglaUfInicio) {
        DFStringValidador.exatamente2(siglaUfInicio, "UF do inicio da prestacao");
        this.siglaUfInicio = siglaUfInicio;
    }

    public String getCodigoMunicipioFim() {
        return this.codigoMunicipioFim;
    }

    public void setCodigoMunicipioFim(String codigoMunicipioFim) {
        DFStringValidador.exatamente7N(codigoMunicipioFim, "Codigo do Municipio de termino da prestacao");
        this.codigoMunicipioFim = codigoMunicipioFim;
    }

    public String getDescricaoMunicipioFim() {
        return this.descricaoMunicipioFim;
    }

    public void setDescricaoMunicipioFim(String descricaoMunicipioFim) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioFim, "Nome do Municipio do termino da prestacao");
        this.descricaoMunicipioFim = descricaoMunicipioFim;
    }

    public String getSiglaUfFim() {
        return this.siglaUfFim;
    }

    public void setSiglaUfFim(String siglaUfFim) {
        DFStringValidador.exatamente2(siglaUfFim, "UF do termino da prestacao");
        this.siglaUfFim = siglaUfFim;
    }

    public CTRetirada getRetira() {
        return this.retira;
    }

    public void setRetira(CTRetirada retira) {
        this.retira = retira;
    }

    public String getDetalheRetira() {
        return this.detalheRetira;
    }

    public void setDetalheRetira(String detalheRetira) {
        DFStringValidador.tamanho160(detalheRetira, "Detalhes da retirada");
        this.detalheRetira = detalheRetira;
    }

    public CTIndicadorTomador getIndIEToma() {
        return this.indIEToma;
    }

    public void setIndIEToma(CTIndicadorTomador indIEToma) {
        this.indIEToma = indIEToma;
    }

    public CTeNotaInfoIdentificacaoTomadorServico3 getTomadorServico3() {
        return this.tomadorServico3;
    }

    public void setTomadorServico3(CTeNotaInfoIdentificacaoTomadorServico3 toma3) {
        this.tomadorServico3 = toma3;
    }

    public CTeNotaInfoIdentificacaoTomadorServico4 getTomadorServico4() {
        return this.tomadorServico4;
    }

    public void setTomadorServico4(CTeNotaInfoIdentificacaoTomadorServico4 toma4) {
        this.tomadorServico4 = toma4;
    }

    public LocalDateTime getDataContingencia() {
        return this.dataContingencia;
    }

    public void setDataContingencia(LocalDateTime dataContingencia) {
        this.dataContingencia = dataContingencia;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        DFStringValidador.tamanho15a256(justificativa, "Justificativa da entrada em contingencia");
        this.justificativa = justificativa;
    }
}

