/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="refNF")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoCTeNormalInfoCTeSubstituicaoTomadorICMSReferenciaNF
extends DFBase {
    private static final long serialVersionUID = -7563695523675903335L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="mod")
    private String modelo;
    @Element(name="serie")
    private String serie;
    @Element(name="subserie", required=false)
    private String subserie;
    @Element(name="nro")
    private String numeroDocumento;
    @Element(name="valor")
    private String valor;
    @Element(name="dEmi")
    private LocalDate dataEmissao;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        DFStringValidador.cpf(cpf);
        this.cpf = cpf;
    }

    public String getModelo() {
        return this.modelo;
    }

    public void setModelo(String modelo) {
        DFStringValidador.exatamente2(modelo, "Modelo do Documento Fiscal");
        this.modelo = modelo;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        DFStringValidador.tamanho3N(serie, "Serie do documento fiscal");
        this.serie = serie;
    }

    public String getSubserie() {
        return this.subserie;
    }

    public void setSubserie(String subserie) {
        DFStringValidador.tamanho3N(this.serie, "Subserie do documento fiscal");
        this.subserie = subserie;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        DFStringValidador.tamanho6N(numeroDocumento, "N\u00famero do documento fiscal");
        this.numeroDocumento = numeroDocumento;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valor, "Valor do documento fiscal");
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }
}

