/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infDocRef")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoCTeNormalInfoDocumentos
extends DFBase {
    private static final long serialVersionUID = 8490041070801837687L;
    @Element(name="nDoc", required=false)
    private String numeroDocumento;
    @Element(name="serie", required=false)
    private String serie;
    @Element(name="subserie", required=false)
    private String subserie;
    @Element(name="dEmi", required=false)
    private LocalDate dataEmissao;
    @Element(name="vDoc", required=false)
    private String valorDocumento;
    @Element(name="chBPe", required=false)
    private String chaveBilhetePassagem;

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        DFStringValidador.tamanho20(numeroDocumento, "Numero Documento");
        this.numeroDocumento = numeroDocumento;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        DFStringValidador.tamanho3(serie, "Serie");
        this.serie = serie;
    }

    public String getSubserie() {
        return this.subserie;
    }

    public void setSubserie(String subserie) {
        DFStringValidador.tamanho3(subserie, "Subserie");
        this.subserie = subserie;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getValorDocumento() {
        return this.valorDocumento;
    }

    public void setValorDocumento(BigDecimal valorDocumento) {
        this.valorDocumento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorDocumento, "Valor Documento");
    }

    public String getChaveBilhetePassagem() {
        return this.chaveBilhetePassagem;
    }

    public void setChaveBilhetePassagem(String chaveBilhetePassagem) {
        DFStringValidador.exatamente44N(chaveBilhetePassagem, "Chave de acesso do Bilhete de Passagem Eletr\u00f4nico");
        this.chaveBilhetePassagem = chaveBilhetePassagem;
    }
}

