/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.os.CTeOSEnderecoEmitente;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoEmitente
extends DFBase {
    private static final long serialVersionUID = 3236506485275091047L;
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="IEST", required=false)
    private String inscricaoEstadualST;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private CTeOSEnderecoEmitente endereco;
    @Element(name="CRT", required=false)
    private String tipoRegimeTributario;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        DFStringValidador.inscricaoEstadualSemIsencao(inscricaoEstadual);
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getInscricaoEstadualST() {
        return this.inscricaoEstadualST;
    }

    public void setInscricaoEstadualST(String inscricaoEstadualST) {
        DFStringValidador.tamanho14N(inscricaoEstadualST, "Inscri\u00e7\u00e3o Estadual do Substituto Tribut\u00e1rio");
        this.inscricaoEstadualST = inscricaoEstadualST;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String xNome) {
        DFStringValidador.tamanho2ate60(xNome, "Raz\u00e3o social ou Nome do emitente");
        this.razaoSocial = xNome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String xFant) {
        DFStringValidador.tamanho2ate60(xFant, "Nome fantasia");
        this.nomeFantasia = xFant;
    }

    public CTeOSEnderecoEmitente getEnderEmit() {
        return this.endereco;
    }

    public void setEnderEmit(CTeOSEnderecoEmitente enderEmit) {
        this.endereco = enderEmit;
    }

    public String getTipoRegimeTributario() {
        return this.tipoRegimeTributario;
    }

    public CTeOSInfoEmitente setTipoRegimeTributario(String tipoRegimeTributario) {
        this.tipoRegimeTributario = tipoRegimeTributario;
        return this;
    }
}

