/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeDetalhamentoEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeEnviaEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeInfoEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeProtocoloEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeRetornoCancelamento;
import com.fincatto.documentofiscal.cte300.parsers.CTChaveParser;
import com.fincatto.documentofiscal.cte300.webservices.recepcaoevento.RecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCancelamento
implements DFLog {
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_CANCELAMENTO = "110111";
    private final CTeConfig config;

    WSCancelamento(CTeConfig config) {
        this.config = config;
    }

    CTeRetornoCancelamento cancelaNotaAssinada(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = this.efetuaCancelamento(eventoAssinadoXml, chaveAcesso);
        return (CTeRetornoCancelamento)this.config.getPersister().read(CTeRetornoCancelamento.class, omElementResult.toString());
    }

    CTeRetornoCancelamento cancelaNota(String chaveAcesso, String numeroProtocolo, String motivo) throws Exception {
        String cancelamentoNotaXML = this.gerarDadosCancelamento(chaveAcesso, numeroProtocolo, motivo).toString();
        String xmlAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cancelamentoNotaXML);
        OMElement omElementResult = this.efetuaCancelamento(xmlAssinado, chaveAcesso);
        return (CTeRetornoCancelamento)this.config.getPersister().read(CTeRetornoCancelamento.class, omElementResult.toString());
    }

    private OMElement efetuaCancelamento(String xmlAssinado, String chaveAcesso) throws Exception {
        CTChaveParser ctChaveParser = new CTChaveParser(chaveAcesso);
        RecepcaoEventoStub.CteCabecMsg cabec = new RecepcaoEventoStub.CteCabecMsg();
        cabec.setCUF(ctChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cabec.setVersaoDados(DFBigDecimalValidador.tamanho5Com2CasasDecimais(VERSAO_LEIAUTE, "Versao do Evento"));
        RecepcaoEventoStub.CteCabecMsgE cabecE = new RecepcaoEventoStub.CteCabecMsgE();
        cabecE.setCteCabecMsg(cabec);
        RecepcaoEventoStub.CteDadosMsg dados = new RecepcaoEventoStub.CteDadosMsg();
        OMElement omElementXML = AXIOMUtil.stringToOM((String)xmlAssinado);
        this.getLogger().debug(omElementXML.toString());
        dados.setExtraElement(omElementXML);
        CTAutorizador31 autorizador = CTAutorizador31.valueOfChaveAcesso(chaveAcesso);
        String urlWebService = autorizador.getRecepcaoEvento(this.config.getAmbiente());
        if (urlWebService == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + ctChaveParser.getModelo().name() + ", autorizador " + autorizador.name());
        }
        RecepcaoEventoStub.CteRecepcaoEventoResult cteRecepcaoEventoResult = new RecepcaoEventoStub(urlWebService, this.config).cteRecepcaoEvento(dados, cabecE);
        OMElement omElementResult = cteRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(omElementResult.toString());
        return omElementResult;
    }

    private CTeProtocoloEventoCancelamento gerarDadosCancelamento(String chaveAcesso, String numeroProtocolo, String motivo) {
        CTChaveParser chaveParser = new CTChaveParser(chaveAcesso);
        CTeEnviaEventoCancelamento cancelamento = new CTeEnviaEventoCancelamento();
        cancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        cancelamento.setJustificativa(motivo.trim());
        cancelamento.setProtocoloAutorizacao(numeroProtocolo);
        CTeDetalhamentoEventoCancelamento cTeDetalhamentoEventoCancelamento = new CTeDetalhamentoEventoCancelamento();
        cTeDetalhamentoEventoCancelamento.setVersaoEvento(VERSAO_LEIAUTE);
        cTeDetalhamentoEventoCancelamento.setEventoCancelamento(cancelamento);
        CTeInfoEventoCancelamento infoEvento = new CTeInfoEventoCancelamento();
        infoEvento.setAmbiente(this.config.getAmbiente());
        infoEvento.setChave(chaveAcesso);
        infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        infoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        infoEvento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, chaveAcesso, "1"));
        infoEvento.setNumeroSequencialEvento(1);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setCodigoEvento(EVENTO_CANCELAMENTO);
        infoEvento.setCancelamento(cTeDetalhamentoEventoCancelamento);
        CTeEventoCancelamento cTeEventoCancelamento = new CTeEventoCancelamento();
        cTeEventoCancelamento.setInfoEvento(infoEvento);
        cTeEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        CTeProtocoloEventoCancelamento cTeProtocoloEventoCancelamento = new CTeProtocoloEventoCancelamento();
        cTeProtocoloEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        cTeProtocoloEventoCancelamento.setEvento(cTeEventoCancelamento);
        return cTeProtocoloEventoCancelamento;
    }
}

