/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTEventoInutilizacaoDados;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTeRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.cte300.webservices.inutilizacao.CteInutilizacaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSInutilizacao {
    private static final String VERSAO_SERVICO = "3.00";
    private static final String NOME_SERVICO = "INUTILIZAR";
    private static final Logger LOGGER = LoggerFactory.getLogger(WSInutilizacao.class);
    private final CTeConfig config;

    WSInutilizacao(CTeConfig config) {
        this.config = config;
    }

    CTeRetornoEventoInutilizacao inutilizaNotaAssinada(String eventoAssinadoXml, DFModelo modelo) throws Exception {
        OMElement omElementResult = this.efetuaInutilizacao(eventoAssinadoXml, modelo);
        return (CTeRetornoEventoInutilizacao)((Object)new DFPersister().read(CTeRetornoEventoInutilizacao.class, omElementResult.toString()));
    }

    CTeRetornoEventoInutilizacao inutilizaNota(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        String inutilizacaoXMLAssinado = this.getXmlAssinado(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo);
        OMElement omElementResult = this.efetuaInutilizacao(inutilizacaoXMLAssinado, modelo);
        return (CTeRetornoEventoInutilizacao)((Object)new DFPersister().read(CTeRetornoEventoInutilizacao.class, omElementResult.toString()));
    }

    String getXmlAssinado(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        String inutilizacaoXML = this.geraDadosInutilizacao(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(inutilizacaoXML);
    }

    private OMElement efetuaInutilizacao(String inutilizacaoXMLAssinado, DFModelo modelo) throws Exception {
        CteInutilizacaoStub.CteDadosMsg dados = new CteInutilizacaoStub.CteDadosMsg();
        CteInutilizacaoStub.CteCabecMsgE cabec = new CteInutilizacaoStub.CteCabecMsgE();
        CteInutilizacaoStub.CteCabecMsg param = new CteInutilizacaoStub.CteCabecMsg();
        param.setCUF(this.config.getCUF().getCodigoIbge());
        param.setVersaoDados(VERSAO_SERVICO);
        cabec.setCteCabecMsg(param);
        OMElement omElement = AXIOMUtil.stringToOM((String)inutilizacaoXMLAssinado);
        LOGGER.debug(omElement.toString());
        dados.setExtraElement(omElement);
        CTAutorizador31 autorizador = CTAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String urlWebService = autorizador.getCteInutilizacao(this.config.getAmbiente());
        CteInutilizacaoStub.CteInutilizacaoCTResult nf4Result = new CteInutilizacaoStub(urlWebService, this.config).cteInutilizacaoCT(dados, cabec);
        OMElement dadosRetorno = nf4Result.getExtraElement();
        LOGGER.debug(dadosRetorno.toString());
        return dadosRetorno;
    }

    private CTEnviaEventoInutilizacao geraDadosInutilizacao(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) {
        CTEnviaEventoInutilizacao inutilizacao = new CTEnviaEventoInutilizacao();
        CTEventoInutilizacaoDados dados = new CTEventoInutilizacaoDados();
        dados.setAmbiente(this.config.getAmbiente());
        dados.setAno(anoInutilizacaoNumeracao);
        dados.setCnpj(cnpjEmitente);
        dados.setJustificativa(justificativa);
        dados.setModeloDocumentoFiscal(modelo.getCodigo());
        dados.setNomeServico(NOME_SERVICO);
        dados.setNumeroCTInicial(numeroInicial);
        dados.setNumeroCTFinal(numeroFinal);
        dados.setSerie(serie);
        dados.setUf(this.config.getCUF());
        String numeroInicialTamanhoMaximo = StringUtils.leftPad((String)numeroInicial, (int)9, (String)"0");
        String numeroFinalTamanhoMaximo = StringUtils.leftPad((String)numeroFinal, (int)9, (String)"0");
        String serieTamanhoMaximo = StringUtils.leftPad((String)serie, (int)3, (String)"0");
        dados.setIdentificador("ID" + this.config.getCUF().getCodigoIbge() + cnpjEmitente + modelo.getCodigo() + serieTamanhoMaximo + numeroInicialTamanhoMaximo + numeroFinalTamanhoMaximo);
        inutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        inutilizacao.setDados(dados);
        return inutilizacao;
    }
}

