/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.nota.consulta.CTeNotaConsulta;
import com.fincatto.documentofiscal.cte300.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte300.parsers.CTChaveParser;
import com.fincatto.documentofiscal.cte300.webservices.consulta.CteConsultaStub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.00";
    private final CTeConfig config;

    WSNotaConsulta(CTeConfig config) {
        this.config = config;
    }

    public CTeNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(chaveDeAcesso).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementRetorno = this.efetuaConsulta(omElementConsulta, chaveDeAcesso);
        this.getLogger().debug(omElementRetorno.toString());
        CTeNotaConsultaRetorno retorno = (CTeNotaConsultaRetorno)this.config.getPersister().read(CTeNotaConsultaRetorno.class, omElementRetorno.toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }

    private OMElement efetuaConsulta(OMElement omElementConsulta, String chaveDeAcesso) throws Exception {
        CTChaveParser ctChaveParser = new CTChaveParser(chaveDeAcesso);
        CteConsultaStub.CteCabecMsg cabec = new CteConsultaStub.CteCabecMsg();
        cabec.setCUF(ctChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cabec.setVersaoDados(VERSAO_SERVICO);
        CteConsultaStub.CteCabecMsgE cabecE = new CteConsultaStub.CteCabecMsgE();
        cabecE.setCteCabecMsg(cabec);
        CteConsultaStub.CteDadosMsg dados = new CteConsultaStub.CteDadosMsg();
        dados.setExtraElement(omElementConsulta);
        this.getLogger().debug(cabec.toString());
        CTAutorizador31 autorizador = CTAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String endpoint = autorizador.getCteConsultaProtocolo(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(endpoint);
        CteConsultaStub.CteConsultaCTResult cteConsultaCTResult = new CteConsultaStub(endpoint, this.config).cteConsultaCT(dados, cabecE);
        return cteConsultaCTResult.getExtraElement();
    }

    private CTeNotaConsulta gerarDadosConsulta(String chaveDeAcesso) {
        CTeNotaConsulta notaConsulta = new CTeNotaConsulta();
        notaConsulta.setAmbiente(this.config.getAmbiente());
        notaConsulta.setChave(chaveDeAcesso);
        notaConsulta.setServico(NOME_SERVICO);
        notaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return notaConsulta;
    }
}

