/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLote;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLoteRetorno;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.cte300.webservices.recepcao.CteRecepcaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

class WSRecepcaoLote
implements DFLog {
    private static final String CTE_ELEMENTO = "CTe";
    private final CTeConfig config;

    WSRecepcaoLote(CTeConfig config) {
        this.config = config;
    }

    public CTeEnvioLoteRetornoDados envioRecepcao(CTeEnvioLote cteRecepcaoLote) throws Exception {
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cteRecepcaoLote.toString(), "infCte");
        CTeEnvioLote loteAssinado = (CTeEnvioLote)this.config.getPersister().read(CTeEnvioLote.class, documentoAssinado);
        CTeEnvioLoteRetorno retorno = this.comunicaLote(documentoAssinado);
        return new CTeEnvioLoteRetornoDados(retorno, loteAssinado);
    }

    private CTeEnvioLoteRetorno comunicaLote(String loteAssinadoXml) throws Exception {
        DFXMLValidador.validaLoteCTe300(loteAssinadoXml);
        OMElement omElement = this.cteToOMElement(loteAssinadoXml);
        CteRecepcaoStub.CteDadosMsg dados = new CteRecepcaoStub.CteDadosMsg();
        dados.setExtraElement(omElement);
        CteRecepcaoStub.CteCabecMsgE cabecalhoSOAP = this.getCabecalhoSOAP();
        this.getLogger().debug(omElement.toString());
        CTAutorizador31 autorizador = CTAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String endpoint = autorizador.getCteRecepcao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        CteRecepcaoStub.CteRecepcaoLoteResult autorizacaoLoteResult = new CteRecepcaoStub(endpoint, this.config).cteRecepcaoLote(dados, cabecalhoSOAP);
        CTeEnvioLoteRetorno retorno = (CTeEnvioLoteRetorno)this.config.getPersister().read(CTeEnvioLoteRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }

    private CteRecepcaoStub.CteCabecMsgE getCabecalhoSOAP() {
        CteRecepcaoStub.CteCabecMsg cabecalho = new CteRecepcaoStub.CteCabecMsg();
        cabecalho.setCUF(this.config.getCUF().getCodigoIbge());
        cabecalho.setVersaoDados("3.00");
        CteRecepcaoStub.CteCabecMsgE cabecalhoSOAP = new CteRecepcaoStub.CteCabecMsgE();
        cabecalhoSOAP.setCteCabecMsg(cabecalho);
        return cabecalhoSOAP;
    }

    private OMElement cteToOMElement(String documento) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(documento));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement ome = builder.getDocumentElement();
        Iterator children = ome.getChildrenWithLocalName(CTE_ELEMENTO);
        while (children.hasNext()) {
            OMElement omElement = (OMElement)children.next();
            if (omElement == null || !CTE_ELEMENTO.equals(omElement.getLocalName())) continue;
            omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/cte", null);
        }
        return ome;
    }
}

