/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.enviolote.consulta.CTeConsultaRecLote;
import com.fincatto.documentofiscal.cte300.classes.enviolote.consulta.CTeConsultaRecLoteRet;
import com.fincatto.documentofiscal.cte300.webservices.retrecepcao.CteRetRecepcaoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSRecepcaoLoteRetorno
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoLoteRetorno(CTeConfig config) {
        this.config = config;
    }

    CTeConsultaRecLoteRet consultaLote(String numeroRecibo) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(numeroRecibo).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsulta(omElementConsulta);
        this.getLogger().debug(omElementResult.toString());
        return (CTeConsultaRecLoteRet)this.config.getPersister().read(CTeConsultaRecLoteRet.class, omElementResult.toString());
    }

    private OMElement efetuaConsulta(OMElement omElement) throws RemoteException {
        CteRetRecepcaoStub.CteCabecMsg cabec = new CteRetRecepcaoStub.CteCabecMsg();
        cabec.setCUF(this.config.getCUF().getCodigoIbge());
        cabec.setVersaoDados("3.00");
        CteRetRecepcaoStub.CteCabecMsgE cabecE = new CteRetRecepcaoStub.CteCabecMsgE();
        cabecE.setCteCabecMsg(cabec);
        CteRetRecepcaoStub.CteDadosMsg dados = new CteRetRecepcaoStub.CteDadosMsg();
        dados.setExtraElement(omElement);
        CTAutorizador31 autorizador = CTAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String endpoint = autorizador.getCteRetRecepcao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RetRecepcao, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        CteRetRecepcaoStub.CteRetRecepcaoResult autorizacaoLoteResult = new CteRetRecepcaoStub(endpoint, this.config).cteRetRecepcao(dados, cabecE);
        return autorizacaoLoteResult.getExtraElement();
    }

    private CTeConsultaRecLote gerarDadosConsulta(String numeroRecibo) {
        CTeConsultaRecLote consulta = new CTeConsultaRecLote();
        consulta.setNumeroRecebimento(numeroRecibo);
        consulta.setAmbiente(this.config.getAmbiente());
        consulta.setVersao("3.00");
        return consulta;
    }
}

