/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.consultastatusservico.CTeConsStatServ;
import com.fincatto.documentofiscal.cte300.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte300.webservices.statusservico.CteStatusServicoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final CTeConfig config;

    WSStatusConsulta(CTeConfig config) {
        this.config = config;
    }

    CTeConsStatServRet consultaStatus(DFUnidadeFederativa uf) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaStatus(omElementConsulta, uf);
        this.getLogger().debug(omElementResult.toString());
        return (CTeConsStatServRet)this.config.getPersister().read(CTeConsStatServRet.class, omElementResult.toString());
    }

    private static CTeConsStatServ gerarDadosConsulta(CTeConfig config) {
        CTeConsStatServ consStatServ = new CTeConsStatServ();
        consStatServ.setAmbiente(config.getAmbiente());
        consStatServ.setVersao("3.00");
        consStatServ.setServico(NOME_SERVICO);
        return consStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement omElement, DFUnidadeFederativa unidadeFederativa) throws RemoteException {
        CteStatusServicoStub.CteCabecMsg cabec = new CteStatusServicoStub.CteCabecMsg();
        cabec.setCUF(unidadeFederativa.getCodigoIbge());
        cabec.setVersaoDados("3.00");
        CteStatusServicoStub.CteCabecMsgE cabecEnv = new CteStatusServicoStub.CteCabecMsgE();
        cabecEnv.setCteCabecMsg(cabec);
        CteStatusServicoStub.CteDadosMsg dados = new CteStatusServicoStub.CteDadosMsg();
        dados.setExtraElement(omElement);
        CTAutorizador31 autorizador = CTAutorizador31.valueOfCodigoUF(unidadeFederativa);
        String endpoint = autorizador.getCteStatusServico(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + autorizador.name() + ", UF " + unidadeFederativa.name());
        }
        return new CteStatusServicoStub(endpoint, this.config).cteStatusServicoCT(dados, cabecEnv).getExtraElement();
    }
}

