/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.evento.epec;

import com.fincatto.documentofiscal.cte400.classes.CTFinalidade;
import com.fincatto.documentofiscal.cte400.classes.CTModal;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeTipoEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.epec.CTeTomadorEpec;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="evEPECCTe")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeEnviaEventoEpec
extends CTeTipoEvento {
    private static final long serialVersionUID = -3353875431330243137L;
    @Element(name="xJust")
    private String descricaoJustificativaContingencia;
    @Element(name="vICMS")
    private String valorICMS;
    @Element(name="vICMSSTRet")
    private String valorICMSSTRetido;
    @Element(name="vTPrest")
    private String valorTotalPrestacaoServico;
    @Element(name="vCarga")
    private String valorTotalCarga;
    @Element(name="toma4")
    private CTeTomadorEpec indicadorTomadorServico4;
    @Element(name="modal")
    private CTModal modalidadeFrete;
    @Element(name="UFIni")
    private String siglaUfInicio;
    @Element(name="UFFim")
    private String siglaUfFim;
    @Element(name="tpCTe")
    private CTFinalidade finalidade;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao;

    public String getDescricaoJustificativaContingencia() {
        return this.descricaoJustificativaContingencia;
    }

    public void setDescricaoJustificativaContingencia(String descricaoJustificativaContingencia) {
        DFStringValidador.tamanho15a255(descricaoJustificativaContingencia, "Justificativa Contingencia");
        this.descricaoJustificativaContingencia = descricaoJustificativaContingencia;
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public void setValorICMS(BigDecimal valorICMS) {
        this.valorICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMS, "Valor do ICMS");
    }

    public String getValorICMSSTRetido() {
        return this.valorICMSSTRetido;
    }

    public void setValorICMSSTRetido(BigDecimal valorICMSSTRetido) {
        this.valorICMSSTRetido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSSTRetido, "Valor do ICMS ST retido");
    }

    public String getValorTotalPrestacaoServico() {
        return this.valorTotalPrestacaoServico;
    }

    public void setValorTotalPrestacaoServico(BigDecimal valorTotalPrestacaoServico) {
        this.valorTotalPrestacaoServico = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalPrestacaoServico, "Valor Total da Presta\u00e7\u00e3o de Servi\u00e7o");
    }

    public String getValorTotalCarga() {
        return this.valorTotalCarga;
    }

    public void setValorTotalCarga(BigDecimal valorTotalCarga) {
        this.valorTotalCarga = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalCarga, "Valor Total da Carga");
    }

    public CTeTomadorEpec getIndicadorTomadorServico4() {
        return this.indicadorTomadorServico4;
    }

    public void setIndicadorTomadorServico4(CTeTomadorEpec indicadorTomadorServico4) {
        this.indicadorTomadorServico4 = indicadorTomadorServico4;
    }

    public CTModal getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(CTModal modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public String getSiglaUfInicio() {
        return this.siglaUfInicio;
    }

    public void setSiglaUfInicio(String siglaUfInicio) {
        DFStringValidador.exatamente2(siglaUfInicio, "UF do in\u00edcio da presta\u00e7\u00e3o");
        this.siglaUfInicio = siglaUfInicio;
    }

    public String getSiglaUfFim() {
        return this.siglaUfFim;
    }

    public void setSiglaUfFim(String siglaUfFim) {
        DFStringValidador.exatamente2(siglaUfFim, "UF do fim da presta\u00e7\u00e3o");
        this.siglaUfFim = siglaUfFim;
    }

    public CTFinalidade getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(CTFinalidade finalidade) {
        this.finalidade = finalidade;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime dataEmissao) {
        this.dataEmissao = dataEmissao;
    }
}

