/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infNF")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoNF
extends DFBase {
    private static final long serialVersionUID = 6286219809877808613L;
    @Element(name="nRoma", required=false)
    private String numeroRomaneio;
    @Element(name="nPed", required=false)
    private String numeroPedidoNF;
    @Element(name="mod")
    private String modeloNF;
    @Element(name="serie")
    private String serie;
    @Element(name="nDoc")
    private String numeroDocumento;
    @Element(name="dEmi")
    private LocalDate dataEmissao;
    @Element(name="vBC")
    private String valorBcICMS;
    @Element(name="vICMS")
    private String valorICMS;
    @Element(name="vBCST")
    private String valorBcICMSST;
    @Element(name="vST")
    private String valorICMSST;
    @Element(name="vProd")
    private String valorTotalProdutos;
    @Element(name="vNF")
    private String valorTotalNF;
    @Element(name="nCFOP")
    private String CFOP;
    @Element(name="nPeso", required=false)
    private String valorPesoTotal;
    @Element(name="PIN", required=false)
    private String pinSUFRAMA;
    @Element(name="dPrev", required=false)
    private LocalDate dataPrevistaEntrega;
    @ElementList(name="infUnidCarga", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidadeCarga;
    @ElementList(name="infUnidTransp", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidadeTransporte;

    public String getNumeroRomaneio() {
        return this.numeroRomaneio;
    }

    public void setNumeroRomaneio(String numeroRomaneio) {
        DFStringValidador.tamanho20(numeroRomaneio, "N\u00famero do Romaneio da NF");
        this.numeroRomaneio = numeroRomaneio;
    }

    public String getNumeroPedidoNF() {
        return this.numeroPedidoNF;
    }

    public void setNumeroPedidoNF(String numeroPedidoNF) {
        DFStringValidador.tamanho20(numeroPedidoNF, "N\u00famero do Pedido da NF");
        this.numeroPedidoNF = numeroPedidoNF;
    }

    public String getModeloNF() {
        return this.modeloNF;
    }

    public void setModeloNF(String modeloNF) {
        this.modeloNF = modeloNF;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        DFStringValidador.tamanho3(serie, "S\u00e9rie");
        this.serie = serie;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        DFStringValidador.tamanho20(numeroDocumento, "N\u00famero");
        this.numeroDocumento = numeroDocumento;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getValorBcICMS() {
        return this.valorBcICMS;
    }

    public void setValorBcICMS(BigDecimal valorBcICMS) {
        this.valorBcICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorBcICMS, "Valor da Base de C\u00e1lculo do ICMS");
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public void setValorICMS(BigDecimal valorICMS) {
        this.valorICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMS, "Valor Total do ICMS");
    }

    public String getValorBcICMSST() {
        return this.valorBcICMSST;
    }

    public void setValorBcICMSST(BigDecimal valorBcICMSST) {
        this.valorBcICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorBcICMSST, "Valor da Base de C\u00e1lculo do ICMS ST");
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public void setValorICMSST(BigDecimal valorICMSST) {
        this.valorICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSST, "Valor Total do ICMS ST");
    }

    public String getValorTotalProdutos() {
        return this.valorTotalProdutos;
    }

    public void setValorTotalProdutos(BigDecimal valorTotalProdutos) {
        this.valorTotalProdutos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalProdutos, "Valor Total dos Produtos");
    }

    public String getValorTotalNF() {
        return this.valorTotalNF;
    }

    public void setValorTotalNF(BigDecimal valorTotalNF) {
        this.valorTotalNF = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorTotalNF, "Valor Total da NF");
    }

    public String getCFOP() {
        return this.CFOP;
    }

    public void setCFOP(String cFOP) {
        DFStringValidador.exatamente4N(cFOP, "CFOP");
        this.CFOP = cFOP;
    }

    public String getValorPesoTotal() {
        return this.valorPesoTotal;
    }

    public void setValorPesoTotal(BigDecimal valorPesoTotal) {
        this.valorPesoTotal = DFBigDecimalValidador.tamanho15Com3CasasDecimais(valorPesoTotal, "Peso total em Kg");
    }

    public String getPinSUFRAMA() {
        return this.pinSUFRAMA;
    }

    public void setPinSUFRAMA(String pinSUFRAMA) {
        DFStringValidador.tamanho2a9N(pinSUFRAMA, "PIN SUFRAMA");
        this.pinSUFRAMA = pinSUFRAMA;
    }

    public LocalDate getDataPrevistaEntrega() {
        return this.dataPrevistaEntrega;
    }

    public void setDataPrevistaEntrega(LocalDate dataPrevistaEntrega) {
        this.dataPrevistaEntrega = dataPrevistaEntrega;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> getInfoUnidadeCarga() {
        return this.infoUnidadeCarga;
    }

    public void setInfoUnidadeCarga(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidadeCarga) {
        this.infoUnidadeCarga = infoUnidadeCarga;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> getInfoUnidadeTransporte() {
        return this.infoUnidadeTransporte;
    }

    public void setInfoUnidadeTransporte(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidadeTransporte) {
        this.infoUnidadeTransporte = infoUnidadeTransporte;
    }
}

