/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infOutros")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoOutros
extends DFBase {
    private static final long serialVersionUID = -1108430703882605623L;
    @Element(name="tpDoc")
    private String tipoDocumento;
    @Element(name="descOutros", required=false)
    private String descricao;
    @Element(name="nDoc", required=false)
    private String numero;
    @Element(name="dEmi", required=false)
    private LocalDate dataEmissao;
    @Element(name="vDocFisc", required=false)
    private String valorDocumentoFiscal;
    @Element(name="dPrev", required=false)
    private LocalDate dataPrevisaoEntrega;
    @ElementList(name="infUnidCarga", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidCarga;
    @ElementList(name="infUnidTransp", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidTransporte;

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        DFStringValidador.tamanho100(descricao, "Descri\u00e7\u00e3o do documento");
        this.descricao = descricao;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        DFStringValidador.tamanho20(numero, "N\u00famero documento");
        this.numero = numero;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getValorDocumentoFiscal() {
        return this.valorDocumentoFiscal;
    }

    public void setValorDocumentoFiscal(BigDecimal valorDocumentoFiscal) {
        this.valorDocumentoFiscal = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorDocumentoFiscal, "Valor do documento");
    }

    public LocalDate getDataPrevisaoEntrega() {
        return this.dataPrevisaoEntrega;
    }

    public void setDataPrevisaoEntrega(LocalDate dataPrevisaoEntrega) {
        this.dataPrevisaoEntrega = dataPrevisaoEntrega;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> getInfoUnidCarga() {
        return this.infoUnidCarga;
    }

    public void setInfoUnidCarga(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidCarga) {
        this.infoUnidCarga = infoUnidCarga;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> getInfoUnidTransporte() {
        return this.infoUnidTransporte;
    }

    public void setInfoUnidTransporte(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidTransporte) {
        this.infoUnidTransporte = infoUnidTransporte;
    }
}

