/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="aquav")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoModalAquaviario
extends DFBase {
    private static final long serialVersionUID = 8840293884140190481L;
    @Element(name="vPrest")
    private String valorPrestacao;
    @Element(name="vAFRMM")
    private String valorAdicionalFrete;
    @Element(name="xNavio")
    private String identificacaoNavio;
    @ElementList(name="balsa", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> balsa;
    @Element(name="nViag", required=false)
    private String numeroViagem;
    @Element(name="direc")
    private String direcao;
    @Element(name="irin")
    private String irin;
    @ElementList(name="detCont", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> container;

    public String getValorPrestacao() {
        return this.valorPrestacao;
    }

    public void setValorPrestacao(BigDecimal valorPrestacao) {
        this.valorPrestacao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorPrestacao, "Valor da Presta\u00e7\u00e3o Base de C\u00e1lculo do AFRMM");
    }

    public String getValorAdicionalFrete() {
        return this.valorAdicionalFrete;
    }

    public void setValorAdicionalFrete(BigDecimal valorAdicionalFrete) {
        this.valorAdicionalFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorAdicionalFrete, "AFRMM (Adicional de Frete para Renova\u00e7\u00e3o da Marinha Mercante)");
    }

    public String getIdentificacaoNavio() {
        return this.identificacaoNavio;
    }

    public void setIdentificacaoNavio(String identificacaoNavio) {
        DFStringValidador.tamanho60(identificacaoNavio, "Identifica\u00e7\u00e3o do Navio");
        this.identificacaoNavio = identificacaoNavio;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> getBalsa() {
        return this.balsa;
    }

    public void setBalsa(List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> balsa) {
        DFListValidador.tamanho3(balsa, "");
        this.balsa = balsa;
    }

    public String getNumeroViagem() {
        return this.numeroViagem;
    }

    public void setNumeroViagem(String numeroViagem) {
        DFStringValidador.tamanho10(numeroViagem, "N\u00famero da Viagem");
        this.numeroViagem = numeroViagem;
    }

    public String getDirecao() {
        return this.direcao;
    }

    public void setDirecao(String direcao) {
        this.direcao = direcao;
    }

    public String getIrin() {
        return this.irin;
    }

    public void setIrin(String irin) {
        DFStringValidador.tamanho10(irin, "Irin do navio");
        this.irin = irin;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> getContainer() {
        return this.container;
    }

    public void setContainer(List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> container) {
        this.container = container;
    }
}

