/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="veicNovos")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalVeiculosTransportados
extends DFBase {
    private static final long serialVersionUID = 8915096979850630016L;
    @Element(name="chassi")
    private String chassi;
    @Element(name="cCor")
    private String codigoCor;
    @Element(name="xCor")
    private String descricaoCor;
    @Element(name="cMod")
    private String codigoMarcaModelo;
    @Element(name="vUnit")
    private String valorUnitario;
    @Element(name="vFrete")
    private String valorFrete;

    public String getChassi() {
        return this.chassi;
    }

    public void setChassi(String chassi) {
        DFStringValidador.exatamente17(chassi, "Chassi do ve\u00edculo");
        this.chassi = chassi;
    }

    public String getCodigoCor() {
        return this.codigoCor;
    }

    public void setCodigoCor(String codigoCor) {
        DFStringValidador.tamanho4(codigoCor, "Cor do ve\u00edculo");
        this.codigoCor = codigoCor;
    }

    public String getDescricaoCor() {
        return this.descricaoCor;
    }

    public void setDescricaoCor(String descricaoCor) {
        DFStringValidador.tamanho40(descricaoCor, "Descri\u00e7\u00e3o da cor");
        this.descricaoCor = descricaoCor;
    }

    public String getCodigoMarcaModelo() {
        return this.codigoMarcaModelo;
    }

    public void setCodigoMarcaModelo(String codigoMarcaModelo) {
        DFStringValidador.tamanho6(codigoMarcaModelo, "C\u00f3digo Marca Modelo");
        this.codigoMarcaModelo = codigoMarcaModelo;
    }

    public String getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(BigDecimal valorUnitario) {
        this.valorUnitario = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorUnitario, "Valor Unit\u00e1rio do Ve\u00edculo");
    }

    public String getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(BigDecimal valorFrete) {
        this.valorFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorFrete, "Frete Unit\u00e1rio");
    }
}

