/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacaoTomadorServico3;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacaoTomadorServico4;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = 7938149076755500266L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF;
    @Element(name="cCT")
    private String codigoNumerico;
    @Element(name="CFOP")
    private String cfop;
    @Element(name="natOp")
    private String naturezaOperacao;
    @Element(name="mod")
    private DFModelo modelo;
    @Element(name="serie")
    private Integer serie;
    @Element(name="nCT")
    private Integer numero;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao;
    @Element(name="tpImp")
    private String tipoImpressao;
    @Element(name="tpEmis")
    private String tipoEmissao;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="tpAmb")
    private String ambiente;
    @Element(name="tpCTe")
    private String finalidade;
    @Element(name="procEmi")
    private String processoEmissao;
    @Element(name="verProc")
    private String versaoProcessoEmissao;
    @Element(name="indGlobalizado", required=false)
    private Integer indicadorGlobalizado;
    @Element(name="cMunEnv")
    private String codigoMunicipioEnvio;
    @Element(name="xMunEnv")
    private String descricaoMunicipioEnvio;
    @Element(name="UFEnv")
    private String siglaUFEnvio;
    @Element(name="modal")
    private String modalidadeFrete;
    @Element(name="tpServ")
    private String tipoServico;
    @Element(name="cMunIni")
    private String codigoMunicipioInicio;
    @Element(name="xMunIni")
    private String descricaoMunicipioInicio;
    @Element(name="UFIni")
    private String siglaUfInicio;
    @Element(name="cMunFim")
    private String codigoMunicipioFim;
    @Element(name="xMunFim")
    private String descricaoMunicipioFim;
    @Element(name="UFFim")
    private String siglaUfFim;
    @Element(name="retira")
    private String retira;
    @Element(name="xDetRetira", required=false)
    private String detalheRetira;
    @Element(name="indIEToma")
    private String indIEToma;
    @Element(name="toma3", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico3 tomadorServico3;
    @Element(name="toma4", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico4 tomadorServico4;
    @Element(name="dhCont", required=false)
    private LocalDateTime dataContingencia;
    @Element(name="xJust", required=false)
    private String justificativa;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa codigoUF) {
        this.codigoUF = codigoUF;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String codigoNumerico) {
        DFStringValidador.exatamente8N(codigoNumerico, "Codigo Numerico");
        this.codigoNumerico = codigoNumerico;
    }

    public String getCfop() {
        return this.cfop;
    }

    public void setCfop(String cfop) {
        DFStringValidador.exatamente4N(cfop, "CFOP");
        this.cfop = cfop;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(String naturezaOperacao) {
        DFStringValidador.tamanho2ate60(naturezaOperacao, "Natureza da Operacao");
        this.naturezaOperacao = naturezaOperacao;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public void setModelo(DFModelo modelo) {
        this.modelo = modelo;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer serie) {
        DFIntegerValidador.tamanho3(serie, "Serie");
        this.serie = serie;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        DFIntegerValidador.tamanho9(numero, "Numero");
        this.numero = numero;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getTipoImpressao() {
        return this.tipoImpressao;
    }

    public void setTipoImpressao(String tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }

    public String getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(String tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        DFIntegerValidador.exatamente1(digitoVerificador, "DV");
        this.digitoVerificador = digitoVerificador;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public String getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(String finalidade) {
        this.finalidade = finalidade;
    }

    public String getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(String processoEmissao) {
        this.processoEmissao = processoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String versaoProcessoEmissao) {
        DFStringValidador.tamanho20(versaoProcessoEmissao, "Versao Aplicativo Emissor");
        this.versaoProcessoEmissao = versaoProcessoEmissao;
    }

    public Integer getIndicadorGlobalizado() {
        return this.indicadorGlobalizado;
    }

    public void setIndicadorGlobalizado(Integer indicadorGlobalizado) {
        DFIntegerValidador.exatamente1(indicadorGlobalizado, "Indicador de CT-e Globalizado");
        this.indicadorGlobalizado = indicadorGlobalizado;
    }

    public String getCodigoMunicipioEnvio() {
        return this.codigoMunicipioEnvio;
    }

    public void setCodigoMunicipioEnvio(String codigoMunicipioEnvio) {
        DFStringValidador.exatamente7N(codigoMunicipioEnvio, "Codigo do Municipio de envio do CT-e");
        this.codigoMunicipioEnvio = codigoMunicipioEnvio;
    }

    public String getDescricaoMunicipioEnvio() {
        return this.descricaoMunicipioEnvio;
    }

    public void setDescricaoMunicipioEnvio(String descricaoMunicipioEnvio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioEnvio, "Nome do Municipio de envio do CT-e");
        this.descricaoMunicipioEnvio = descricaoMunicipioEnvio;
    }

    public String getSiglaUFEnvio() {
        return this.siglaUFEnvio;
    }

    public void setSiglaUFEnvio(String siglaUFEnvio) {
        DFStringValidador.exatamente2(siglaUFEnvio, "Sigla da UF de envio do CT-e");
        this.siglaUFEnvio = siglaUFEnvio;
    }

    public String getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(String modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public String getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(String tipoServico) {
        this.tipoServico = tipoServico;
    }

    public String getCodigoMunicipioInicio() {
        return this.codigoMunicipioInicio;
    }

    public void setCodigoMunicipioInicio(String codigoMunicipioInicio) {
        DFStringValidador.exatamente7N(codigoMunicipioInicio, "Codigo do Municipio de inicio da prestacao");
        this.codigoMunicipioInicio = codigoMunicipioInicio;
    }

    public String getDescricaoMunicipioInicio() {
        return this.descricaoMunicipioInicio;
    }

    public void setDescricaoMunicipioInicio(String descricaoMunicipioInicio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioInicio, "Nome do Municipio do inicio da prestacao");
        this.descricaoMunicipioInicio = descricaoMunicipioInicio;
    }

    public String getSiglaUfInicio() {
        return this.siglaUfInicio;
    }

    public void setSiglaUfInicio(String siglaUfInicio) {
        DFStringValidador.exatamente2(siglaUfInicio, "UF do inicio da prestacao");
        this.siglaUfInicio = siglaUfInicio;
    }

    public String getCodigoMunicipioFim() {
        return this.codigoMunicipioFim;
    }

    public void setCodigoMunicipioFim(String codigoMunicipioFim) {
        DFStringValidador.exatamente7N(codigoMunicipioFim, "Codigo do Municipio de termino da prestacao");
        this.codigoMunicipioFim = codigoMunicipioFim;
    }

    public String getDescricaoMunicipioFim() {
        return this.descricaoMunicipioFim;
    }

    public void setDescricaoMunicipioFim(String descricaoMunicipioFim) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioFim, "Nome do Municipio do termino da prestacao");
        this.descricaoMunicipioFim = descricaoMunicipioFim;
    }

    public String getSiglaUfFim() {
        return this.siglaUfFim;
    }

    public void setSiglaUfFim(String siglaUfFim) {
        DFStringValidador.exatamente2(siglaUfFim, "UF do termino da prestacao");
        this.siglaUfFim = siglaUfFim;
    }

    public String getRetira() {
        return this.retira;
    }

    public void setRetira(String retira) {
        this.retira = retira;
    }

    public String getDetalheRetira() {
        return this.detalheRetira;
    }

    public void setDetalheRetira(String detalheRetira) {
        DFStringValidador.tamanho160(detalheRetira, "Detalhes da retirada");
        this.detalheRetira = detalheRetira;
    }

    public String getIndIEToma() {
        return this.indIEToma;
    }

    public void setIndIEToma(String indIEToma) {
        this.indIEToma = indIEToma;
    }

    public CTeNotaInfoIdentificacaoTomadorServico3 getTomadorServico3() {
        return this.tomadorServico3;
    }

    public void setTomadorServico3(CTeNotaInfoIdentificacaoTomadorServico3 toma3) {
        this.tomadorServico3 = toma3;
    }

    public CTeNotaInfoIdentificacaoTomadorServico4 getTomadorServico4() {
        return this.tomadorServico4;
    }

    public void setTomadorServico4(CTeNotaInfoIdentificacaoTomadorServico4 toma4) {
        this.tomadorServico4 = toma4;
    }

    public LocalDateTime getDataContingencia() {
        return this.dataContingencia;
    }

    public void setDataContingencia(LocalDateTime dataContingencia) {
        this.dataContingencia = dataContingencia;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        DFStringValidador.tamanho15a256(justificativa, "Justificativa da entrada em contingencia");
        this.justificativa = justificativa;
    }
}

