/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ICMS60")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoInformacoesRelativasImpostosICMS60
extends DFBase {
    private static final long serialVersionUID = 2843992966457411104L;
    @Element(name="CST")
    private String codigoSituacaoTributaria;
    @Element(name="vBCSTRet")
    private String baseCalculoICMSSTRetido;
    @Element(name="vICMSSTRet")
    private String valorICMSSTRetido;
    @Element(name="pICMSSTRet")
    private String aliquotaICMSSTRetido;
    @Element(name="vCred", required=false)
    private String valorCredito;
    @Element(name="vICMSDeson", required=false)
    private String valorICMSDesoneracao;
    @Element(name="cBenef", required=false)
    private String codigoBeneficioFiscal;

    public String getCodigoSituacaoTributaria() {
        return this.codigoSituacaoTributaria;
    }

    public void setCodigoSituacaoTributaria(String codigoSituacaoTributaria) {
        this.codigoSituacaoTributaria = codigoSituacaoTributaria;
    }

    public String getBaseCalculoICMSSTRetido() {
        return this.baseCalculoICMSSTRetido;
    }

    public void setBaseCalculoICMSSTRetido(BigDecimal baseCalculoICMSSTRetido) {
        this.baseCalculoICMSSTRetido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(baseCalculoICMSSTRetido, "Valor da BC do ICMS ST retido");
    }

    public String getValorICMSSTRetido() {
        return this.valorICMSSTRetido;
    }

    public void setValorICMSSTRetido(BigDecimal valorICMSSTRetido) {
        this.valorICMSSTRetido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSSTRetido, "Valor do ICMS ST retido");
    }

    public String getAliquotaICMSSTRetido() {
        return this.aliquotaICMSSTRetido;
    }

    public void setAliquotaICMSSTRetido(BigDecimal aliquotaICMSSTRetido) {
        this.aliquotaICMSSTRetido = DFBigDecimalValidador.tamanho5Com2CasasDecimais(aliquotaICMSSTRetido, "Al\u00edquota do ICMS");
    }

    public String getValorCredito() {
        return this.valorCredito;
    }

    public void setValorCredito(BigDecimal valorCredito) {
        this.valorCredito = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorCredito, "Valor do Cr\u00e9dito outorgado/Presumido");
    }

    public String getValorICMSDesoneracao() {
        return this.valorICMSDesoneracao;
    }

    public void setValorICMSDesoneracao(BigDecimal valorICMSDesoneracao) {
        this.valorICMSDesoneracao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorICMSDesoneracao, "Valor de ICMS de Desonera\u00e7\u00e3o");
    }

    public String getCodigoBeneficioFiscal() {
        return this.codigoBeneficioFiscal;
    }

    public void setCodigoBeneficioFiscal(String codigoBeneficioFiscal) {
        this.codigoBeneficioFiscal = codigoBeneficioFiscal;
    }
}

