/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ICMSUFFim")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoInformacoesRelativasImpostosICMSPartilha
extends DFBase {
    private static final long serialVersionUID = -3330020091021958480L;
    @Element(name="vBCUFFim")
    private String bcICMS;
    @Element(name="pFCPUFFim")
    private String aliquotaFCP;
    @Element(name="pICMSUFFim")
    private String aliquotaInterna;
    @Element(name="pICMSInter")
    private String aliquotaInterestadual;
    @Element(name="pICMSInterPart", required=false)
    private String aliquotaPartilha;
    @Element(name="vFCPUFFim")
    private String valorFCP;
    @Element(name="vICMSUFFim")
    private String valorUfDestino;
    @Element(name="vICMSUFIni")
    private String valorUf;

    public String getBcICMS() {
        return this.bcICMS;
    }

    public void setBcICMS(BigDecimal bcICMS) {
        this.bcICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bcICMS, "Valor da BC do ICMS na UF de t\u00e9rmino da presta\u00e7\u00e3o do servi\u00e7o de transporte");
    }

    public String getAliquotaFCP() {
        return this.aliquotaFCP;
    }

    public void setAliquotaFCP(BigDecimal aliquotaFCP) {
        this.aliquotaFCP = DFBigDecimalValidador.tamanho5Com2CasasDecimais(aliquotaFCP, "Percentual do ICMS relativo ao Fundo de Combate \u00e0 pobreza (FCP)");
    }

    public String getAliquotaInterna() {
        return this.aliquotaInterna;
    }

    public void setAliquotaInterna(BigDecimal aliquotaInterna) {
        this.aliquotaInterna = DFBigDecimalValidador.tamanho5Com2CasasDecimais(aliquotaInterna, "Al\u00edquota interna da UF de t\u00e9rmino da presta\u00e7\u00e3o do servi\u00e7o de transporte");
    }

    public String getAliquotaInterestadual() {
        return this.aliquotaInterestadual;
    }

    public void setAliquotaInterestadual(BigDecimal aliquotaInterestadual) {
        this.aliquotaInterestadual = DFBigDecimalValidador.tamanho5Com2CasasDecimais(aliquotaInterestadual, "Al\u00edquota interestadual das UF envolvidas");
    }

    public String getAliquotaPartilha() {
        return this.aliquotaPartilha;
    }

    public void setAliquotaPartilha(BigDecimal aliquotaPartilha) {
        this.aliquotaPartilha = DFBigDecimalValidador.tamanho5Com2CasasDecimais(aliquotaPartilha, "Percentual provis\u00f3rio de partilha entre os estados");
    }

    public String getValorFCP() {
        return this.valorFCP;
    }

    public void setValorFCP(BigDecimal valorFCP) {
        this.valorFCP = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorFCP, "Valor do ICMS relativo ao Fundo de Combate \u00e1 Pobreza (FCP)");
    }

    public String getValorUfDestino() {
        return this.valorUfDestino;
    }

    public void setValorUfDestino(BigDecimal valorUfDestino) {
        this.valorUfDestino = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorUfDestino, "Valor do ICMS de partilha para a UF de t\u00e9rmino da presta\u00e7\u00e3o do servi\u00e7o de transporte");
    }

    public String getValorUf() {
        return this.valorUf;
    }

    public void setValorUf(BigDecimal valorUf) {
        this.valorUf = DFBigDecimalValidador.tamanho15Com2CasasDecimais(valorUf, "Valor do ICMS de partilha para a UF de in\u00edcio da presta\u00e7\u00e3o do servi\u00e7o de transporte");
    }
}

