/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="receb")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoRecebedorCarga
extends DFBase {
    private static final long serialVersionUID = 3386397042057340032L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="fone", required=false)
    private String telefone;
    @Element(name="enderReceb")
    private CTeNotaEndereco endereco;
    @Element(name="email", required=false)
    private String email;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        DFStringValidador.cpf(cpf);
        this.cpf = cpf;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        DFStringValidador.inscricaoEstadual(inscricaoEstadual);
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        DFStringValidador.tamanho2ate60(razaoSocial, "Raz\u00e3o Social ou Nome");
        this.razaoSocial = razaoSocial;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        DFStringValidador.telefone(telefone);
        this.telefone = telefone;
    }

    public CTeNotaEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(CTeNotaEndereco endereco) {
        this.endereco = endereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        DFStringValidador.tamanho60(email, "Endere\u00e7o de email");
        DFStringValidador.email(email);
        this.email = email;
    }
}

