/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota.consulta;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="consSitCTe")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaConsulta
extends DFBase {
    private static final long serialVersionUID = 402162498360517770L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="xServ")
    private String servico;
    @Element(name="chCTe")
    private String chave;

    public void setVersao(BigDecimal versao) {
        this.versao = DFBigDecimalValidador.tamanho4Com2CasasDecimais(versao, "Versao Nota Consulta");
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public void setServico(String servico) {
        this.servico = servico;
    }

    public void setChave(String chave) {
        DFStringValidador.exatamente44N(chave, "Chave de Acesso Nota Consulta");
        this.chave = chave;
    }

    public String getVersao() {
        return this.versao;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public String getServico() {
        return this.servico;
    }

    public String getChave() {
        return this.chave;
    }
}

