/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte400.classes.CTTipoProprietario;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="prop")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoCTeNormalInfoModalRodoviarioVeiculoProprietario
extends DFBase {
    private static final long serialVersionUID = -7624273019279765397L;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="TAF", required=false)
    private String termoAutorizacaoFretamento;
    @Element(name="NroRegEstadual", required=false)
    private String numeroRegistroEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="UF")
    private String unidadeFederativa;
    @Element(name="tpProp", required=false)
    private CTTipoProprietario tipoProprietario;

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em proprietario do Ve\u00edculo ");
        }
        this.cpf = DFStringValidador.cpf(cpf, "proprietario do Ve\u00edculo");
        this.cpf = cpf;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em proprietario do Ve\u00edculo");
        }
        this.cnpj = DFStringValidador.cnpj(cnpj, "proprietario do Ve\u00edculo");
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        DFStringValidador.inscricaoEstadual(inscricaoEstadual);
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    public void setUnidadeFederativa(String unidadeFederativa) {
        this.unidadeFederativa = unidadeFederativa;
    }

    public void setUnidadeFederativa(DFUnidadeFederativa unidadeFederativa) {
        this.unidadeFederativa = unidadeFederativa.getCodigo();
    }

    public String getTermoAutorizacaoFretamento() {
        return this.termoAutorizacaoFretamento;
    }

    public void setTermoAutorizacaoFretamento(String termoAutorizacaoFretamento) {
        DFStringValidador.tamanho12(termoAutorizacaoFretamento, "Termo de Autoriza\u00e7\u00e3o de Fretamento");
        this.termoAutorizacaoFretamento = termoAutorizacaoFretamento;
    }

    public String getNumeroRegistroEstadual() {
        return this.numeroRegistroEstadual;
    }

    public void setNumeroRegistroEstadual(String numeroRegistroEstadual) {
        DFStringValidador.tamanho25N(numeroRegistroEstadual, "N\u00famero do Registro Estadual");
        this.numeroRegistroEstadual = numeroRegistroEstadual;
    }

    public CTTipoProprietario getTipoProprietario() {
        return this.tipoProprietario;
    }

    public void setTipoProprietario(CTTipoProprietario tipoProprietario) {
        this.tipoProprietario = tipoProprietario;
    }
}

