/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.os;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTTipoEmissao;
import com.fincatto.documentofiscal.cte400.classes.CTFinalidade;
import com.fincatto.documentofiscal.cte400.classes.CTIndicadorTomador;
import com.fincatto.documentofiscal.cte400.classes.CTModal;
import com.fincatto.documentofiscal.cte400.classes.CTProcessoEmissao;
import com.fincatto.documentofiscal.cte400.classes.CTTipoImpressao;
import com.fincatto.documentofiscal.cte400.classes.CTTipoServicoOS;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOSInfoIdentificacaoUfPercurso;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -8453848058358735289L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF;
    @Element(name="cCT")
    private String codigoNumerico;
    @Element(name="CFOP")
    private String cfop;
    @Element(name="natOp")
    private String naturezaOperacao;
    @Element(name="mod")
    private DFModelo modelo;
    @Element(name="serie")
    private Integer serie;
    @Element(name="nCT")
    private Integer numero;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao;
    @Element(name="tpImp")
    private CTTipoImpressao tipoImpressao;
    @Element(name="tpEmis")
    private CTTipoEmissao tipoEmissao;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="tpCTe")
    private CTFinalidade finalidade;
    @Element(name="procEmi")
    private CTProcessoEmissao processoEmissao;
    @Element(name="verProc")
    private String versaoProcessoEmissao;
    @Element(name="cMunEnv")
    private String codigoMunicipioEnvio;
    @Element(name="xMunEnv")
    private String descricaoMunicipioEnvio;
    @Element(name="UFEnv")
    private String siglaUFEnvio;
    @Element(name="modal")
    private CTModal modalidadeFrete;
    @Element(name="tpServ")
    private CTTipoServicoOS tipoServico;
    @Element(name="indIEToma")
    private CTIndicadorTomador indIEToma;
    @Element(name="cMunIni")
    private String codigoMunicipioInicio;
    @Element(name="xMunIni")
    private String descricaoMunicipioInicio;
    @Element(name="UFIni")
    private String siglaUfInicio;
    @Element(name="cMunFim")
    private String codigoMunicipioFim;
    @Element(name="xMunFim")
    private String descricaoMunicipioFim;
    @Element(name="UFFim")
    private String siglaUfFim;
    @ElementList(entry="infPercurso", inline=true, required=false)
    private List<CTeOSInfoIdentificacaoUfPercurso> identificacaoUfPercursos;
    @Element(name="dhCont", required=false)
    private LocalDateTime dataContingencia;
    @Element(name="xJust", required=false)
    private String justificativa;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa codigoUF) {
        this.codigoUF = codigoUF;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String codigoNumerico) {
        DFStringValidador.exatamente8N(codigoNumerico, "Codigo Numerico");
        this.codigoNumerico = codigoNumerico;
    }

    public String getCfop() {
        return this.cfop;
    }

    public void setCfop(String cfop) {
        DFStringValidador.exatamente4N(cfop, "CFOP");
        this.cfop = cfop;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(String naturezaOperacao) {
        DFStringValidador.tamanho2ate60(naturezaOperacao, "Natureza da Operacao");
        this.naturezaOperacao = naturezaOperacao;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public void setModelo(DFModelo modelo) {
        this.modelo = modelo;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer serie) {
        DFIntegerValidador.tamanho3(serie, "Serie");
        this.serie = serie;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        DFIntegerValidador.tamanho9(numero, "Numero");
        this.numero = numero;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public CTTipoImpressao getTipoImpressao() {
        return this.tipoImpressao;
    }

    public void setTipoImpressao(CTTipoImpressao tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }

    public CTTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(CTTipoEmissao tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        DFIntegerValidador.exatamente1(digitoVerificador, "DV");
        this.digitoVerificador = digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public CTFinalidade getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(CTFinalidade finalidade) {
        this.finalidade = finalidade;
    }

    public CTProcessoEmissao getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(CTProcessoEmissao processoEmissao) {
        this.processoEmissao = processoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String versaoProcessoEmissao) {
        DFStringValidador.tamanho20(versaoProcessoEmissao, "Versao Aplicativo Emissor");
        this.versaoProcessoEmissao = versaoProcessoEmissao;
    }

    public String getCodigoMunicipioEnvio() {
        return this.codigoMunicipioEnvio;
    }

    public void setCodigoMunicipioEnvio(String codigoMunicipioEnvio) {
        DFStringValidador.exatamente7N(codigoMunicipioEnvio, "Codigo do Municipio de envio do CT-e");
        this.codigoMunicipioEnvio = codigoMunicipioEnvio;
    }

    public String getDescricaoMunicipioEnvio() {
        return this.descricaoMunicipioEnvio;
    }

    public void setDescricaoMunicipioEnvio(String descricaoMunicipioEnvio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioEnvio, "Nome do Municipio de envio do CT-e");
        this.descricaoMunicipioEnvio = descricaoMunicipioEnvio;
    }

    public String getSiglaUFEnvio() {
        return this.siglaUFEnvio;
    }

    public void setSiglaUFEnvio(String siglaUFEnvio) {
        DFStringValidador.exatamente2(siglaUFEnvio, "Sigla da UF de envio do CT-e");
        this.siglaUFEnvio = siglaUFEnvio;
    }

    public CTModal getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(CTModal modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public CTTipoServicoOS getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(CTTipoServicoOS tipoServico) {
        this.tipoServico = tipoServico;
    }

    public String getCodigoMunicipioInicio() {
        return this.codigoMunicipioInicio;
    }

    public void setCodigoMunicipioInicio(String codigoMunicipioInicio) {
        DFStringValidador.exatamente7N(codigoMunicipioInicio, "Codigo do Municipio de inicio da prestacao");
        this.codigoMunicipioInicio = codigoMunicipioInicio;
    }

    public String getDescricaoMunicipioInicio() {
        return this.descricaoMunicipioInicio;
    }

    public void setDescricaoMunicipioInicio(String descricaoMunicipioInicio) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioInicio, "Nome do Municipio do inicio da prestacao");
        this.descricaoMunicipioInicio = descricaoMunicipioInicio;
    }

    public String getSiglaUfInicio() {
        return this.siglaUfInicio;
    }

    public void setSiglaUfInicio(String siglaUfInicio) {
        DFStringValidador.exatamente2(siglaUfInicio, "UF do inicio da prestacao");
        this.siglaUfInicio = siglaUfInicio;
    }

    public String getCodigoMunicipioFim() {
        return this.codigoMunicipioFim;
    }

    public void setCodigoMunicipioFim(String codigoMunicipioFim) {
        DFStringValidador.exatamente7N(codigoMunicipioFim, "Codigo do Municipio de termino da prestacao");
        this.codigoMunicipioFim = codigoMunicipioFim;
    }

    public String getDescricaoMunicipioFim() {
        return this.descricaoMunicipioFim;
    }

    public void setDescricaoMunicipioFim(String descricaoMunicipioFim) {
        DFStringValidador.tamanho2ate60(descricaoMunicipioFim, "Nome do Municipio do termino da prestacao");
        this.descricaoMunicipioFim = descricaoMunicipioFim;
    }

    public String getSiglaUfFim() {
        return this.siglaUfFim;
    }

    public void setSiglaUfFim(String siglaUfFim) {
        DFStringValidador.exatamente2(siglaUfFim, "UF do termino da prestacao");
        this.siglaUfFim = siglaUfFim;
    }

    public CTIndicadorTomador getIndIEToma() {
        return this.indIEToma;
    }

    public void setIndIEToma(CTIndicadorTomador indIEToma) {
        this.indIEToma = indIEToma;
    }

    public LocalDateTime getDataContingencia() {
        return this.dataContingencia;
    }

    public void setDataContingencia(LocalDateTime dataContingencia) {
        this.dataContingencia = dataContingencia;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        DFStringValidador.tamanho15a256(justificativa, "Justificativa da entrada em contingencia");
        this.justificativa = justificativa;
    }

    public List<CTeOSInfoIdentificacaoUfPercurso> getIdentificacaoUfPercursos() {
        return this.identificacaoUfPercursos;
    }

    public void setIdentificacaoUfPercursos(List<CTeOSInfoIdentificacaoUfPercurso> identificacaoUfPercursos) {
        this.identificacaoUfPercursos = identificacaoUfPercursos;
    }
}

