/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.comprovanteentrega.CTeEnviaEventoCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamentoComprovanteEntrega
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento do Comprovante de Entrega do CT-e";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_COMPROVANTE_DE_ENTREGA = "110181";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSCancelamentoComprovanteEntrega(CTeConfig config) {
        super(config, modelosPermitidos);
    }

    CTeEventoRetorno cancelaComprovanteEntregaAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = super.efetuaEvento(eventoAssinadoXml, chaveAcesso, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, omElementResult.toString());
    }

    CTeEventoRetorno cancelaComprovanteEntrega(String chaveAcesso, String protocoloAutorizacao, String protocoloComprovanteEntrega, int sequencialEvento) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, protocoloAutorizacao, protocoloComprovanteEntrega, sequencialEvento);
        return this.cancelaComprovanteEntregaAssinado(chaveAcesso, xmlAssinado);
    }

    String getXmlAssinado(String chave, String protocoloAutorizacao, String protocoloComprovanteEntrega, int sequencialEvento) throws Exception {
        String xml = this.gerarDadosCancelamentoComprovanteEntrega(chave, protocoloAutorizacao, protocoloComprovanteEntrega, sequencialEvento).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(xml);
    }

    private CTeEvento gerarDadosCancelamentoComprovanteEntrega(String chaveAcesso, String protocoloAutorizacao, String protocoloComprovanteEntrega, int sequencialEvento) throws Exception {
        CTeEnviaEventoCancelamentoComprovanteEntrega cancComprovanteEntrega = new CTeEnviaEventoCancelamentoComprovanteEntrega();
        cancComprovanteEntrega.setDescricaoEvento(DESCRICAO_EVENTO);
        cancComprovanteEntrega.setProtocoloAutorizacao(protocoloAutorizacao);
        cancComprovanteEntrega.setProtocoloComprovanteEntrega(protocoloComprovanteEntrega);
        DFXMLValidador.validaEventoCancelamentoComprovanteEntregaCTe400(cancComprovanteEntrega.toString());
        return super.gerarEvento(chaveAcesso, VERSAO_LEIAUTE, cancComprovanteEntrega, EVENTO_COMPROVANTE_DE_ENTREGA, null, sequencialEvento);
    }
}

