/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.desacordo.CTeEnviaEventoCancelamentoPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamentoPrestacaoEmDesacordo
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento Prestacao do Servico em Desacordo";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_CANCELAMENTO_DESACORDO = "610111";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE, DFModelo.CTeOS);

    WSCancelamentoPrestacaoEmDesacordo(CTeConfig config) {
        super(config, modelosPermitidos);
    }

    CTeEventoRetorno cancelaPrestacaoEmDesacordoAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = this.efetuaEvento(eventoAssinadoXml, chaveAcesso, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, omElementResult.toString());
    }

    CTeEventoRetorno cancelaPrestacaoEmDesacordo(String chaveAcesso, String protocoloDesacordo, String cpfOuCnpj, int sequencialEvento) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, protocoloDesacordo, cpfOuCnpj, sequencialEvento);
        return this.cancelaPrestacaoEmDesacordoAssinado(chaveAcesso, xmlAssinado);
    }

    String getXmlAssinado(String chave, String protocoloDesacordo, String cpfOuCnpj, int sequencialEvento) throws Exception {
        String xml = this.gerarDados(chave, protocoloDesacordo, cpfOuCnpj, sequencialEvento).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(xml);
    }

    private CTeEvento gerarDados(String chaveAcesso, String protocoloDesacordo, String cpfOuCnpj, int sequencialEvento) throws Exception {
        CTeEnviaEventoCancelamentoPrestacaoEmDesacordo cancDesacordo = new CTeEnviaEventoCancelamentoPrestacaoEmDesacordo();
        cancDesacordo.setDescricaoEvento(DESCRICAO_EVENTO);
        cancDesacordo.setProtocoloDesacordo(protocoloDesacordo);
        DFXMLValidador.validaEventoCancelamentoPrestacaoEmDesacordoCTe400(cancDesacordo.toString());
        return super.gerarEvento(chaveAcesso, VERSAO_LEIAUTE, cancDesacordo, EVENTO_CANCELAMENTO_DESACORDO, cpfOuCnpj, sequencialEvento);
    }
}

