/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsulta;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeConsultaV4Stub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public class WSConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private final CTeConfig config;

    WSConsulta(CTeConfig config) {
        this.config = config;
    }

    public CTeNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(chaveDeAcesso).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementRetorno = this.efetuaConsulta(omElementConsulta, chaveDeAcesso);
        this.getLogger().debug(omElementRetorno.toString());
        CTeNotaConsultaRetorno retorno = (CTeNotaConsultaRetorno)this.config.getPersister().read(CTeNotaConsultaRetorno.class, omElementRetorno.toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }

    private OMElement efetuaConsulta(OMElement omElementConsulta, String chaveDeAcesso) throws Exception {
        CTeConsultaV4Stub.CteDadosMsg dados = new CTeConsultaV4Stub.CteDadosMsg();
        dados.setExtraElement(omElementConsulta);
        CTAutorizador400 autorizador = CTAutorizador400.valueOfChaveAcesso(chaveDeAcesso);
        String endpoint = autorizador.getCteConsultaProtocolo(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(endpoint);
        CTeConsultaV4Stub.CteConsultaCTResult cteConsultaCTResult = new CTeConsultaV4Stub(endpoint, this.config).cteConsultaCT(dados);
        return cteConsultaCTResult.getExtraElement();
    }

    private CTeNotaConsulta gerarDadosConsulta(String chaveDeAcesso) {
        CTeNotaConsulta notaConsulta = new CTeNotaConsulta();
        notaConsulta.setAmbiente(this.config.getAmbiente());
        notaConsulta.setChave(chaveDeAcesso);
        notaConsulta.setServico(NOME_SERVICO);
        notaConsulta.setVersao(new BigDecimal("4.00"));
        return notaConsulta;
    }
}

