/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.epec.CTeEnviaEventoEpec;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSEpec
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "EPEC";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_EPEC = "110113";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSEpec(CTeConfig config) {
        super(config, modelosPermitidos);
    }

    CTeEventoRetorno enviaEpecAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = super.efetuaEventoSVC(eventoAssinadoXml, chaveAcesso, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, omElementResult.toString());
    }

    CTeEventoRetorno enviaEpec(String chaveAcesso, CTeEnviaEventoEpec eventoEpec) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, eventoEpec);
        return this.enviaEpecAssinado(chaveAcesso, xmlAssinado);
    }

    String getXmlAssinado(String chave, CTeEnviaEventoEpec eventoEpec) throws Exception {
        String xml = this.gerarDadosEpec(chave, eventoEpec).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(xml);
    }

    private CTeEvento gerarDadosEpec(String chaveAcesso, CTeEnviaEventoEpec eventoEpec) throws Exception {
        eventoEpec.setDescricaoEvento(DESCRICAO_EVENTO);
        DFXMLValidador.validaEventoEpecCTe400(eventoEpec.toString());
        return super.gerarEvento(chaveAcesso, VERSAO_LEIAUTE, eventoEpec, EVENTO_EPEC, null, 1);
    }
}

