/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.cte.webservices.distribuicao.WSDistribuicaoCTe;
import com.fincatto.documentofiscal.cte400.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeOSEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.cartacorrecao.CTeInformacaoCartaCorrecao;
import com.fincatto.documentofiscal.cte400.classes.evento.comprovanteentrega.CTeEnviaEventoComprovanteEntrega;
import com.fincatto.documentofiscal.cte400.classes.evento.epec.CTeEnviaEventoEpec;
import com.fincatto.documentofiscal.cte400.classes.evento.gtv.CTeEnviaEventoGtv;
import com.fincatto.documentofiscal.cte400.classes.evento.insucessoentrega.CTeEnviaEventoInsucessoEntrega;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOS;
import com.fincatto.documentofiscal.cte400.webservices.WSCancelamento;
import com.fincatto.documentofiscal.cte400.webservices.WSCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSCancelamentoInsucessoEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSCancelamentoPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte400.webservices.WSCartaCorrecao;
import com.fincatto.documentofiscal.cte400.webservices.WSComprovanteEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSConsulta;
import com.fincatto.documentofiscal.cte400.webservices.WSEpec;
import com.fincatto.documentofiscal.cte400.webservices.WSGtv;
import com.fincatto.documentofiscal.cte400.webservices.WSInsucessoEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoCTe;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoCTeOS;
import com.fincatto.documentofiscal.cte400.webservices.WSRegistroMultimodal;
import com.fincatto.documentofiscal.cte400.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSStatusConsulta wsStatusConsulta;
    private final WSRecepcaoCTe wsRecepcaoCTe;
    private final WSDistribuicaoCTe wsDistribuicaoCTe;
    private final WSConsulta wsConsulta;
    private final WSCancelamento wsCancelamento;
    private final WSPrestacaoEmDesacordo wsPrestacaoEmDesacordo;
    private final WSRegistroMultimodal wsRegistroMultimodal;
    private final WSCartaCorrecao wsCartaCorrecao;
    private final WSComprovanteEntrega wsComprovanteEntrega;
    private final WSCancelamentoComprovanteEntrega wsCancelamentoComprovanteEntrega;
    private final WSEpec wsEpec;
    private final WSGtv wsGtv;
    private final WSCancelamentoPrestacaoEmDesacordo wsCancelamentoPrestacaoEmDesacordo;
    private final WSInsucessoEntrega wsInsucessoEntrega;
    private final WSCancelamentoInsucessoEntrega wsCancelamentoInsucessoEntrega;
    private final WSRecepcaoCTeOS wsRecepcaoCTeOS;

    public WSFacade(CTeConfig config) throws IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(config), 443));
        this.wsStatusConsulta = new WSStatusConsulta(config);
        this.wsRecepcaoCTe = new WSRecepcaoCTe(config);
        this.wsDistribuicaoCTe = new WSDistribuicaoCTe(config);
        this.wsConsulta = new WSConsulta(config);
        this.wsCancelamento = new WSCancelamento(config);
        this.wsPrestacaoEmDesacordo = new WSPrestacaoEmDesacordo(config);
        this.wsRegistroMultimodal = new WSRegistroMultimodal(config);
        this.wsCartaCorrecao = new WSCartaCorrecao(config);
        this.wsComprovanteEntrega = new WSComprovanteEntrega(config);
        this.wsCancelamentoComprovanteEntrega = new WSCancelamentoComprovanteEntrega(config);
        this.wsEpec = new WSEpec(config);
        this.wsGtv = new WSGtv(config);
        this.wsCancelamentoPrestacaoEmDesacordo = new WSCancelamentoPrestacaoEmDesacordo(config);
        this.wsInsucessoEntrega = new WSInsucessoEntrega(config);
        this.wsCancelamentoInsucessoEntrega = new WSCancelamentoInsucessoEntrega(config);
        this.wsRecepcaoCTeOS = new WSRecepcaoCTeOS(config);
    }

    public CTeConsStatServRet consultaStatus(DFUnidadeFederativa uf) throws Exception {
        return this.wsStatusConsulta.consultaStatus(uf);
    }

    public CTeEnvioRetornoDados enviaCTe(CTeNota cte) throws Exception {
        return this.wsRecepcaoCTe.enviaCTe(cte);
    }

    public CTDistribuicaoIntRetorno consultarDistribuicaoCTe(String cpfOuCnpj, DFUnidadeFederativa uf, String nsu, String ultNsu) throws Exception {
        return this.wsDistribuicaoCTe.consultar(cpfOuCnpj, uf, nsu, ultNsu);
    }

    public CTeNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        return this.wsConsulta.consultaNota(chaveDeAcesso);
    }

    public CTeEventoRetorno cancelaNota(String chave, String numeroProtocolo, String motivo) throws Exception {
        return this.wsCancelamento.cancelaNota(chave, numeroProtocolo, motivo);
    }

    public CTeEventoRetorno cancelaNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoCancelamento(String chave, String numeroProtocolo, String motivo) throws Exception {
        return this.wsCancelamento.getXmlAssinado(chave, numeroProtocolo, motivo);
    }

    public CTeEventoRetorno cancelaComprovanteEntrega(String chave, String protocoloAutorizacao, String protocoloComprovanteEntrega, int sequencialEvento) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.cancelaComprovanteEntrega(chave, protocoloAutorizacao, protocoloComprovanteEntrega, sequencialEvento);
    }

    public CTeEventoRetorno cancelaComprovanteEntregaAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.cancelaComprovanteEntregaAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoCancelamentoComprovanteEntrega(String chave, String protocoloAutorizacao, String protocoloComprovanteEntrega, int sequencialEvento) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.getXmlAssinado(chave, protocoloAutorizacao, protocoloComprovanteEntrega, sequencialEvento);
    }

    public CTeEventoRetorno corrigeNota(String chave, String grupoAlterado, String campoAlterado, String valorAlterado, Integer numeroItemAlterado, int sequencialEvento) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(chave, grupoAlterado, campoAlterado, valorAlterado, numeroItemAlterado, sequencialEvento);
    }

    public CTeEventoRetorno corrigeNota(String chave, List<CTeInformacaoCartaCorrecao> correcoes, int sequencialEvento) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(chave, correcoes, sequencialEvento);
    }

    public CTeEventoRetorno corrigeNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoCartaCorreca(String chave, List<CTeInformacaoCartaCorrecao> correcoes, int sequencialEvento) throws Exception {
        return this.wsCartaCorrecao.getXmlAssinado(chave, correcoes, sequencialEvento);
    }

    public CTeEventoRetorno comprovanteEntrega(String chave, CTeEnviaEventoComprovanteEntrega comprovanteEntrega, int sequencialEvento) throws Exception {
        return this.wsComprovanteEntrega.comprovanteEntrega(chave, comprovanteEntrega, sequencialEvento);
    }

    public CTeEventoRetorno comprovanteEntregaAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsComprovanteEntrega.comprovanteEntregaAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoComprovanteEntrega(String chave, CTeEnviaEventoComprovanteEntrega comprovanteEntrega, int sequencialEvento) throws Exception {
        return this.wsComprovanteEntrega.getXmlAssinado(chave, comprovanteEntrega, sequencialEvento);
    }

    public CTeEventoRetorno enviaEpec(String chave, CTeEnviaEventoEpec eventoEpec) throws Exception {
        return this.wsEpec.enviaEpec(chave, eventoEpec);
    }

    public CTeEventoRetorno enviaEpecAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsEpec.enviaEpecAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoEpec(String chave, CTeEnviaEventoEpec eventoEpec) throws Exception {
        return this.wsEpec.getXmlAssinado(chave, eventoEpec);
    }

    public CTeEventoRetorno enviaGtv(String chave, CTeEnviaEventoGtv eventoGtv, int sequencialEvento) throws Exception {
        return this.wsGtv.enviaGtv(chave, eventoGtv, sequencialEvento);
    }

    public CTeEventoRetorno enviaGtvAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsGtv.enviaGtvAssinada(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoGtv(String chave, CTeEnviaEventoGtv eventoGtv, int sequencialEvento) throws Exception {
        return this.wsGtv.getXmlAssinado(chave, eventoGtv, sequencialEvento);
    }

    public CTeEventoRetorno prestacaoEmDesacordo(String chave, String observacao, String cpfOuCnpj, int sequencialEvento) throws Exception {
        return this.wsPrestacaoEmDesacordo.prestacaoEmDesacordo(chave, observacao, cpfOuCnpj, sequencialEvento);
    }

    public CTeEventoRetorno prestacaoEmDesacordoAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsPrestacaoEmDesacordo.prestacaoEmDesacordoAssinada(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoPrestacaoEmDesacordo(String chave, String observacao, String cpfOuCnpj, int sequencialEvento) throws Exception {
        return this.wsPrestacaoEmDesacordo.getXmlAssinado(chave, observacao, cpfOuCnpj, sequencialEvento);
    }

    public CTeEventoRetorno registroMultimodal(String chave, String informacoesAdicionais, String numeroDocumento) throws Exception {
        return this.wsRegistroMultimodal.registroMultimodal(chave, informacoesAdicionais, numeroDocumento);
    }

    public CTeEventoRetorno registroMultimodalAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsRegistroMultimodal.registroMultimodalAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoRegistroMultimodal(String chave, String informacoesAdicionais, String numeroDocumento) throws Exception {
        return this.wsRegistroMultimodal.getXmlAssinado(chave, informacoesAdicionais, numeroDocumento);
    }

    public CTeEventoRetorno cancelaPrestacaoEmDesacordo(String chave, String protocoloDesacordo, String cpfOuCnpj, int sequencialEvento) throws Exception {
        return this.wsCancelamentoPrestacaoEmDesacordo.cancelaPrestacaoEmDesacordo(chave, protocoloDesacordo, cpfOuCnpj, sequencialEvento);
    }

    public CTeEventoRetorno cancelaPrestacaoEmDesacordoAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamentoPrestacaoEmDesacordo.cancelaPrestacaoEmDesacordoAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoCancelamentoPrestacaoEmDesacordo(String chave, String protocoloDesacordo, String cpfOuCnpj, int sequencialEvento) throws Exception {
        return this.wsCancelamentoPrestacaoEmDesacordo.getXmlAssinado(chave, protocoloDesacordo, cpfOuCnpj, sequencialEvento);
    }

    public CTeEventoRetorno cancelaInsucessoEntrega(String chave, String protocoloAutorizacao, String protocoloInsucessoEntrega, int sequencialEvento) throws Exception {
        return this.wsCancelamentoInsucessoEntrega.cancelaInsucessoEntrega(chave, protocoloAutorizacao, protocoloInsucessoEntrega, sequencialEvento);
    }

    public CTeEventoRetorno cancelaInsucessoEntregaAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamentoInsucessoEntrega.cancelaInsucessoEntregaAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoCancelamentoInsucessoEntrega(String chave, String protocoloAutorizacao, String protocoloInsucessoEntrega, int sequencialEvento) throws Exception {
        return this.wsCancelamentoInsucessoEntrega.getXmlAssinado(chave, protocoloAutorizacao, protocoloInsucessoEntrega, sequencialEvento);
    }

    public CTeEventoRetorno insucessoEntrega(String chave, CTeEnviaEventoInsucessoEntrega insucessoEntrega, int sequencialEvento) throws Exception {
        return this.wsInsucessoEntrega.insucessoEntrega(chave, insucessoEntrega, sequencialEvento);
    }

    public CTeEventoRetorno insucessoEntregaAssinado(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsInsucessoEntrega.insucessoEntregaAssinado(chave, eventoAssinadoXml);
    }

    public String getXmlAssinadoInsucessoEntrega(String chave, CTeEnviaEventoInsucessoEntrega insucessoEntrega, int sequencialEvento) throws Exception {
        return this.wsInsucessoEntrega.getXmlAssinado(chave, insucessoEntrega, sequencialEvento);
    }

    public CTeOSEnvioRetornoDados envioRecepcaoLote(CTeOS cteOS) throws Exception {
        return this.wsRecepcaoCTeOS.enviaCTe(cteOS);
    }
}

