/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.gtv.CTeEnviaEventoGtv;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSGtv
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Informacoes da GTV";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_GTV = "110170";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTeOS);

    WSGtv(CTeConfig config) {
        super(config, modelosPermitidos);
    }

    CTeEventoRetorno enviaGtvAssinada(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = super.efetuaEvento(eventoAssinadoXml, chaveAcesso, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, omElementResult.toString());
    }

    CTeEventoRetorno enviaGtv(String chaveAcesso, CTeEnviaEventoGtv eventoGtv, int sequencialEvento) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, eventoGtv, sequencialEvento);
        return this.enviaGtvAssinada(chaveAcesso, xmlAssinado);
    }

    String getXmlAssinado(String chave, CTeEnviaEventoGtv eventoGtv, int sequencialEvento) throws Exception {
        String xml = this.gerarDadosGtv(chave, eventoGtv, sequencialEvento).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(xml);
    }

    private CTeEvento gerarDadosGtv(String chaveAcesso, CTeEnviaEventoGtv eventoGtv, int sequencialEvento) throws Exception {
        eventoGtv.setDescricaoEvento(DESCRICAO_EVENTO);
        DFXMLValidador.validaEventoGtvCTe400(eventoGtv.toString());
        return super.gerarEvento(chaveAcesso, VERSAO_LEIAUTE, eventoGtv, EVENTO_GTV, null, sequencialEvento);
    }
}

