/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetorno;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeRecepcaoSincV4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;

class WSRecepcaoCTe
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoCTe(CTeConfig config) {
        this.config = config;
    }

    public CTeEnvioRetornoDados enviaCTe(CTeNota cte) throws Exception {
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cte.toString(), "infCte");
        CTeNota cteAssinado = (CTeNota)this.config.getPersister().read(CTeNota.class, documentoAssinado);
        CTeEnvioRetorno retorno = this.comunicaLote(documentoAssinado);
        return new CTeEnvioRetornoDados(retorno, cteAssinado);
    }

    private CTeEnvioRetorno comunicaLote(String cteAssinadoXml) throws Exception {
        String conteudoCompactado;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(cteAssinadoXml.getBytes(StandardCharsets.UTF_8));
            }
            conteudoCompactado = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        CTeRecepcaoSincV4Stub.CteDadosMsg dados = new CTeRecepcaoSincV4Stub.CteDadosMsg();
        dados.setCteDadosMsg(conteudoCompactado);
        CTAutorizador400 autorizador = CTAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String endpoint = autorizador.getCteRecepcaoSinc(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        CTeRecepcaoSincV4Stub.CteRecepcaoResult autorizacaoLoteResult = new CTeRecepcaoSincV4Stub(endpoint, this.config).cteRecepcao(dados);
        CTeEnvioRetorno retorno = (CTeEnvioRetorno)this.config.getPersister().read(CTeEnvioRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }
}

