/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeOSEnvioRetorno;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeOSEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOS;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeRecepcaoOSV4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;

class WSRecepcaoCTeOS
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoCTeOS(CTeConfig config) {
        this.config = config;
    }

    public CTeOSEnvioRetornoDados enviaCTe(CTeOS cteOS) throws Exception {
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(cteOS.toString(), "infCte");
        CTeOS cteAssinado = (CTeOS)this.config.getPersister().read(CTeOS.class, documentoAssinado);
        CTeOSEnvioRetorno retorno = this.comunicaLote(documentoAssinado);
        return new CTeOSEnvioRetornoDados(retorno, cteAssinado);
    }

    private CTeOSEnvioRetorno comunicaLote(String cteAssinadoXml) throws Exception {
        String conteudoCompactado;
        DFXMLValidador.validaNotaCTeOS400(cteAssinadoXml);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(cteAssinadoXml.getBytes(StandardCharsets.UTF_8));
            }
            conteudoCompactado = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        CTeRecepcaoOSV4Stub.CteDadosMsg dados = new CTeRecepcaoOSV4Stub.CteDadosMsg();
        dados.setCteDadosMsg(conteudoCompactado);
        CTAutorizador400 autorizador = CTAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String endpoint = autorizador.getCteRecepcaoSinc(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao OS, autorizador " + autorizador.name() + ", UF " + this.config.getCUF().name());
        }
        CTeRecepcaoOSV4Stub.CteRecepcaoOSResult autorizacaoLoteResult = new CTeRecepcaoOSV4Stub(endpoint, this.config).cteRecepcaoOS(dados);
        CTeOSEnvioRetorno retorno = (CTeOSEnvioRetorno)this.config.getPersister().read(CTeOSEnvioRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(retorno.toString());
        return retorno;
    }
}

