/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.multimodal.CTeEnviaEventoRegistroMultimodal;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSRegistroMultimodal
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Registro Multimodal";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_REGISTRO_MULTIMODAL = "110160";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSRegistroMultimodal(CTeConfig config) {
        super(config, modelosPermitidos);
    }

    CTeEventoRetorno registroMultimodalAssinado(String chaveAcesso, String eventoAssinadoXml) throws Exception {
        OMElement omElementResult = super.efetuaEvento(eventoAssinadoXml, chaveAcesso, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, omElementResult.toString());
    }

    CTeEventoRetorno registroMultimodal(String chaveAcesso, String informacoesAdicionais, String numeroDocumento) throws Exception {
        String xmlAssinado = this.getXmlAssinado(chaveAcesso, informacoesAdicionais, numeroDocumento);
        return this.registroMultimodalAssinado(chaveAcesso, xmlAssinado);
    }

    String getXmlAssinado(String chave, String informacoesAdicionais, String numeroDocumento) throws Exception {
        String xml = this.gerarDadosRegistroMultimodal(chave, informacoesAdicionais, numeroDocumento).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(xml);
    }

    private CTeEvento gerarDadosRegistroMultimodal(String chaveAcesso, String informacoesAdicionais, String numeroDocumento) throws Exception {
        CTeEnviaEventoRegistroMultimodal registroMultimodal = new CTeEnviaEventoRegistroMultimodal();
        registroMultimodal.setDescricaoEvento(DESCRICAO_EVENTO);
        registroMultimodal.setInformacoesAdicionais(informacoesAdicionais.trim());
        registroMultimodal.setNumero(numeroDocumento.trim());
        DFXMLValidador.validaEventoRegistroMultimodalCTe400(registroMultimodal.toString());
        return super.gerarEvento(chaveAcesso, VERSAO_LEIAUTE, registroMultimodal, EVENTO_REGISTRO_MULTIMODAL, null, 1);
    }
}

