/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.consultastatusservico.CTeConsStatServ;
import com.fincatto.documentofiscal.cte400.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeStatusServicoV4Stub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final CTeConfig config;

    WSStatusConsulta(CTeConfig config) {
        this.config = config;
    }

    CTeConsStatServRet consultaStatus(DFUnidadeFederativa uf) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config, uf).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaStatus(omElementConsulta, uf);
        this.getLogger().debug(omElementResult.toString());
        return (CTeConsStatServRet)this.config.getPersister().read(CTeConsStatServRet.class, omElementResult.toString());
    }

    private static CTeConsStatServ gerarDadosConsulta(CTeConfig config, DFUnidadeFederativa uf) {
        CTeConsStatServ consStatServ = new CTeConsStatServ();
        consStatServ.setVersao("4.00");
        consStatServ.setAmbiente(config.getAmbiente());
        consStatServ.setUf(uf.getCodigoIbge());
        consStatServ.setServico(NOME_SERVICO);
        return consStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement omElement, DFUnidadeFederativa unidadeFederativa) throws RemoteException {
        CTeStatusServicoV4Stub.CteDadosMsg dados = new CTeStatusServicoV4Stub.CteDadosMsg();
        dados.setExtraElement(omElement);
        CTAutorizador400 autorizador = CTAutorizador400.valueOfCodigoUF(unidadeFederativa);
        String endpoint = autorizador.getCteStatusServico(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + autorizador.name() + ", UF " + unidadeFederativa.name());
        }
        return new CTeStatusServicoV4Stub(endpoint, this.config).cteStatusServicoCT(dados).getExtraElement();
    }
}

