/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoEmitenteEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoEmitente
extends DFBase {
    private static final long serialVersionUID = 6209368588212530094L;
    private static final String INFO = "Emitente do Manifesto";
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private MDFInfoEmitenteEndereco endereco;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        if (this.cpf != null && cnpj != null) {
            throw new IllegalStateException("Nao pode setar CNPJ caso CPF esteja setado");
        }
        DFStringValidador.cnpj(cnpj);
        this.cnpj = cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        if (this.cnpj != null && cpf != null) {
            throw new IllegalStateException("Nao pode setar CPF caso CNPJ esteja setado");
        }
        DFStringValidador.cpf(cpf);
        this.cpf = cpf;
    }

    public String getCpfj() {
        String cpfj = "";
        if (StringUtils.isNotBlank((CharSequence)this.cpf)) {
            cpfj = this.cpf;
        } else if (StringUtils.isNotBlank((CharSequence)this.cnpj)) {
            cpfj = this.cnpj;
        }
        return cpfj;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = DFStringValidador.inscricaoEstadualSemIsencao(inscricaoEstadual, INFO);
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String xNome) {
        DFStringValidador.tamanho2ate60(xNome, "Raz\u00e3o social ou Nome em Emitente do Manifesto");
        this.razaoSocial = xNome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String xFant) {
        DFStringValidador.tamanho2ate60(xFant, "Nome fantasia em Emitente do Manifesto");
        this.nomeFantasia = xFant;
    }

    public MDFInfoEmitenteEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(MDFInfoEmitenteEndereco endereco) {
        this.endereco = endereco;
    }
}

