/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFModalidadeTransporte;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFProcessoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmitente;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoTranportador;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoIdentificacaoMunicipioCarregamento;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoIdentificacaoUfPercurso;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -106178398166932545L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="tpEmit")
    private MDFTipoEmitente tipoEmitente;
    @Element(name="tpTransp", required=false)
    private MDFTipoTranportador tipoTranportador;
    @Element(name="mod")
    public static final DFModelo MOD = DFModelo.MDFE;
    @Element(name="serie")
    private Integer serie;
    @Element(name="nMDF")
    private Integer numero;
    @Element(name="cMDF")
    private String codigoNumerico;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="modal")
    private MDFModalidadeTransporte modalidadeFrete;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao;
    @Element(name="tpEmis")
    private MDFTipoEmissao tipoEmissao;
    @Element(name="procEmi")
    private MDFProcessoEmissao processoEmissao;
    @Element(name="verProc")
    private String versaoProcessoEmissao;
    @Element(name="UFIni")
    private String unidadeFederativaInicio;
    @Element(name="UFFim")
    private String unidadeFederativaFim;
    @ElementList(entry="infMunCarrega", inline=true)
    private List<MDFInfoIdentificacaoMunicipioCarregamento> municipioCarregamentos;
    @ElementList(entry="infPercurso", inline=true, required=false)
    private List<MDFInfoIdentificacaoUfPercurso> identificacaoUfPercursos;
    @Element(name="dhIniViagem", required=false)
    private ZonedDateTime dataHoraDoInicioViagem;
    @Element(name="indCanalVerde", required=false)
    private String indicadorCanalVerde;
    @Element(name="indCarregaPosterior", required=false)
    private String indicadorCarregaPosterior;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa codigoUF) {
        this.codigoUF = codigoUF;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String codigoNumerico) {
        DFStringValidador.exatamente8N(codigoNumerico, "C\u00f3digo Num\u00e9rico");
        this.codigoNumerico = codigoNumerico;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer serie) {
        DFIntegerValidador.tamanho3(serie, "S\u00e9rie");
        this.serie = serie;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        DFIntegerValidador.tamanho9(numero, "N\u00famero");
        this.numero = numero;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public MDFTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(MDFTipoEmissao tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        DFIntegerValidador.exatamente1(digitoVerificador, "Digito verificador MDF-e");
        this.digitoVerificador = digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente ambiente) {
        this.ambiente = ambiente;
    }

    public MDFProcessoEmissao getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(MDFProcessoEmissao processoEmissao) {
        this.processoEmissao = processoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String versaoProcessoEmissao) {
        DFStringValidador.tamanho20(versaoProcessoEmissao, "Vers\u00e3o Aplicativo Emissor");
        this.versaoProcessoEmissao = versaoProcessoEmissao;
    }

    public MDFModalidadeTransporte getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(MDFModalidadeTransporte modalidadeFrete) {
        this.modalidadeFrete = modalidadeFrete;
    }

    public MDFTipoEmitente getTipoEmitente() {
        return this.tipoEmitente;
    }

    public void setTipoEmitente(MDFTipoEmitente tipoEmitente) {
        this.tipoEmitente = tipoEmitente;
    }

    public MDFTipoTranportador getTipoTranportador() {
        return this.tipoTranportador;
    }

    public void setTipoTranportador(MDFTipoTranportador tipoTranportador) {
        this.tipoTranportador = tipoTranportador;
    }

    public String getUnidadeFederativaInicio() {
        return this.unidadeFederativaInicio;
    }

    public void setUnidadeFederativaInicio(DFUnidadeFederativa unidadeFederativaInicio) {
        this.unidadeFederativaInicio = unidadeFederativaInicio.getCodigo();
    }

    public String getUnidadeFederativaFim() {
        return this.unidadeFederativaFim;
    }

    public void setUnidadeFederativaFim(DFUnidadeFederativa unidadeFederativaFim) {
        this.unidadeFederativaFim = unidadeFederativaFim.getCodigo();
    }

    public List<MDFInfoIdentificacaoMunicipioCarregamento> getMunicipioCarregamentos() {
        return this.municipioCarregamentos;
    }

    public void setMunicipioCarregamentos(List<MDFInfoIdentificacaoMunicipioCarregamento> municipioCarregamentos) {
        this.municipioCarregamentos = DFListValidador.validaListaObrigatoria(municipioCarregamentos, 50, "Munic\u00edpios carregamento MDF-e");
    }

    public List<MDFInfoIdentificacaoUfPercurso> getIdentificacaoUfPercursos() {
        return this.identificacaoUfPercursos;
    }

    public void setIdentificacaoUfPercursos(List<MDFInfoIdentificacaoUfPercurso> identificacaoUfPercursos) {
        this.identificacaoUfPercursos = DFListValidador.validaListaNaoObrigatoria(identificacaoUfPercursos, 25, "UF percurso MDF-e");
    }

    public ZonedDateTime getDataHoraDoInicioViagem() {
        return this.dataHoraDoInicioViagem;
    }

    public void setDataHoraDoInicioViagem(ZonedDateTime dataHoraDoInicioViagem) {
        this.dataHoraDoInicioViagem = dataHoraDoInicioViagem;
    }

    public String getIndicadorCanalVerde() {
        return this.indicadorCanalVerde;
    }

    public void setIndicadorCanalVerde(String indicadorCanalVerde) {
        Object[] enumeration = new String[]{"1"};
        if (StringUtils.isNotBlank((CharSequence)indicadorCanalVerde) && !StringUtils.equalsAny((CharSequence)indicadorCanalVerde, (CharSequence[])enumeration)) {
            throw new IllegalStateException(String.format("Indicador canal verde \"%s\" deve possuir um dos seguintes:'%s' caracteres", indicadorCanalVerde, Arrays.toString(enumeration)));
        }
        this.indicadorCanalVerde = indicadorCanalVerde;
    }

    public String getIndicadorCarregaPosterior() {
        return this.indicadorCarregaPosterior;
    }

    public void setIndicadorCarregaPosterior(String indicadorCarregaPosterior) {
        this.indicadorCarregaPosterior = indicadorCarregaPosterior;
    }
}

